<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Results for query ${query}</title>
  <script type="text/javascript" src="${dataUrl}jquery.min.js"></script>
  <script type="text/javascript" src="${dataUrl}jquery.tablesorter.min.js"></script>
  <link rel="stylesheet" href="${dataUrl}search.css" type="text/css" media="screen, print" />
  <link rel="stylesheet" href="${dataUrl}blue/style.css" type="text/css" media="screen, print" />
</head>

<body id="index" class="home">

<!-- Initialize search input with proper value -->
<script type="text/javascript">
  function go( field ) {
    window.navigate(window.location.href.replace(window.location.search, "?search=" + encodeURIComponent(field.value)));
  }

  function queryString( key ) {
    var re = new RegExp( "[?&]" + key + "=([^&$]*)", "i" );
    var offset = location.search.search( re );
    if ( offset == -1 ) return null;
    return RegExp.$1;
  }

  $(document).ready(function() {
    $("#search").value = decodeURIComponent(queryString('search')); 
    if (!("autofocus" in document.createElement("input"))) {
      $("#search").focus();
    }
  });

  //$(document).ready(function() { $("#results").tablesorter(); } );
</script>

<form>
  <input autofocus size="70" id="search" type="text" name="search" value="${query}" onChange="go(this)" />
</form>

<span class="resultCountText">
<#if resultCount = maxResults>
${resultCount} or more results found.
<#else>
<#if resultCount = 1>
${resultCount} result found.
<#else>
${resultCount} results found.
</#if>
</#if>
</span>

<ol>
<#list results as result>
<li><div class="result">
<a class="emph" href="resource:${result.resource.resource}" <#if result.resource.uri??>title="${result.resource.uri}"</#if>>${result.resource.name}</a>
<#if result.principalTypes??>
is an instance of
<#list result.principalTypes as type>
<a class="small" href="resource:${type.resource}" <#if type.uri??>title="${type.uri}"</#if>>${type.name}</a>
</#list>
and
</#if>
<#if result.parent??>
is a part of <a class="small" href="resource:${result.parent.resource}" <#if result.parent.uri??>title="${result.parent.uri}"</#if>>${result.parent.name}</a>
</#if>
</div></li>
</#list>
</ol>

</body>