/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.wiki.ui;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.document.DocumentResource;
import org.simantics.layer0.Layer0;

public class DefaultWikiTemplateFactory implements DocumentFactory {

    String template;

    public DefaultWikiTemplateFactory(ReadGraph graph, Resource r) {
        template = "";

        try {
            Layer0 l0 = Layer0.getInstance(graph);
            DocumentResource DOC = DocumentResource.getInstance(graph);
            Resource resource = r;

            while(resource != null) {
                if(graph.hasStatement(resource, DOC.HasDocumentTemplate)) {
                    Resource dt = graph.getSingleObject(resource, DOC.HasDocumentTemplate);
                    template = (String)graph.getRelatedValue(dt, DOC.HasDocumentation, Bindings.STRING);
                    break;
                }
                resource = graph.getPossibleObject(resource, l0.PartOf);
            }
        } catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String createDocument() {
        return template;
    }

}
