/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.views.swt;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupportImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.db.request.WriteInterface;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.ontology.ScenegraphResources;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.utils.ui.jface.ActiveSelectionProvider;
import org.simantics.views.swt.ModelledSupport;
import org.simantics.views.swt.SWTViewLoaderProcess;
import org.simantics.views.swt.SimanticsView;
import org.simantics.views.swt.client.base.SWTRoot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelledView
extends SimanticsView
implements IPartListener2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelledView.class);
    public static final int TIME_BEFORE_DISPOSE_WHEN_HIDDEN = 30000;
    private static final boolean DEBUG = false;
    protected Resource runtime;
    protected String configurationURI;
    protected boolean publishSelection = true;
    protected SWTRoot root;
    protected Variable viewVariable;
    protected Function1<Variable, Boolean> onInputChanged = null;
    protected SWTViewLoaderProcess loader;
    protected Composite body;
    protected Composite container;
    protected ModelledSupport support;
    ActiveSelectionProvider selectionProvider = new ActiveSelectionProvider(){

        public void setSelection(ISelection selection) {
            LOGGER.trace("selectionProvider.setSelection( {} )", (Object)selection);
            super.setSelection(selection);
        }
    };
    volatile boolean reallyClearExisting = false;
    Runnable clearExisting = new Runnable(){

        @Override
        public void run() {
            if (!ModelledView.this.reallyClearExisting) {
                return;
            }
            ModelledView.this.viewVariable = null;
            ModelledView.this.onInputChanged = null;
            if (ModelledView.this.loader != null) {
                ModelledView.this.loader.dispose();
                ModelledView.this.loader = null;
            }
            if (ModelledView.this.container != null) {
                final Composite oldContainer = ModelledView.this.container;
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!oldContainer.isDisposed()) {
                            oldContainer.dispose();
                        }
                    }
                });
                if (!ModelledView.this.container.isDisposed()) {
                    GridDataFactory.fillDefaults().exclude(true).applyTo((Control)ModelledView.this.container);
                }
                ModelledView.this.container = null;
            }
            ModelledView.this.root = null;
        }
    };

    protected String configurationURI() {
        return this.configurationURI;
    }

    @Override
    protected WidgetSupportImpl createSupport() {
        try {
            this.runtime = (Resource)Simantics.getSession().sync((WriteInterface)new WriteResultRequest<Resource>((VirtualGraph)Simantics.getSession().getService(VirtualGraph.class)){

                public Resource perform(WriteGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    ScenegraphResources SG = ScenegraphResources.getInstance((ReadGraph)graph);
                    Resource runtime = graph.newResource();
                    graph.claim(runtime, L0.InstanceOf, null, SG.Runtime);
                    return runtime;
                }
            });
        }
        catch (DatabaseException | RuntimeDatabaseException e) {
            LOGGER.error("Failed to initialize modelled widget support runtime scenegraph", e);
        }
        this.support = new ModelledSupport(this);
        return this.support;
    }

    public void fireInput() {
        if (this.onInputChanged != null) {
            this.onInputChanged.apply((Object)this.viewVariable);
        }
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        super.setInitializationData(cfig, propertyName, data);
        if (data instanceof String) {
            String[] parameters;
            String[] stringArray = parameters = ((String)data).split(";");
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                String parameter = stringArray[n2];
                String[] keyValue = parameter.split("=");
                if (keyValue.length > 2) {
                    ErrorLogger.defaultLogWarning((String)("Invalid parameter '" + parameter + ". Complete view argument: " + String.valueOf(data)), null);
                } else {
                    String value;
                    String key = keyValue[0];
                    String string = value = keyValue.length > 1 ? keyValue[1] : "";
                    if ("configurationURI".equals(key)) {
                        this.configurationURI = value;
                    } else if ("noSelectionPublish".equals(key)) {
                        this.publishSelection = false;
                    }
                }
                ++n2;
            }
        }
    }

    protected void doCreateControls(boolean load) {
        if (this.container == null) {
            GridLayoutFactory.fillDefaults().applyTo(this.body);
            this.container = new Composite(this.body, 0);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.container);
            GridLayoutFactory.fillDefaults().applyTo(this.container);
        }
        if (load) {
            try {
                this.loader = new SWTViewLoaderProcess(this, (IWorkbenchSite)this.getSite(), ((Object)((Object)this)).getClass().getSimpleName());
                this.viewVariable = this.loader.getVariable((RequestProcessor)Simantics.getSession(), this.configurationURI(), this.runtime);
                this.onInputChanged = (Function1)Simantics.getSession().syncRequest((Read)new Read<Function1<Variable, Boolean>>(){

                    public Function1<Variable, Boolean> perform(ReadGraph graph) throws DatabaseException {
                        return (Function1)ModelledView.this.viewVariable.getPossiblePropertyValue(graph, "onInputChanged");
                    }
                });
                this.root = (SWTRoot)this.loader.load((RequestProcessor)Simantics.getSession(), this.viewVariable);
                this.root.createControls(this.container);
                this.root.getControl().addListener(12, new Listener(){
                    final SWTViewLoaderProcess oldLoader;
                    {
                        this.oldLoader = ModelledView.this.loader;
                    }

                    public void handleEvent(Event event) {
                        if (this.oldLoader != null && !this.oldLoader.isDisposed()) {
                            this.oldLoader.dispose();
                        }
                    }
                });
                this.body.layout(true);
                LOGGER.trace("PRE: ModelledView({}) site selection provider is {}", (Object)this.configurationURI(), (Object)this.getSite().getSelectionProvider());
                if (this.publishSelection) {
                    this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
                }
                LOGGER.trace("POST: ModelledView({}) site selection provider is {}", (Object)this.configurationURI(), (Object)this.getSite().getSelectionProvider());
            }
            catch (DatabaseException e) {
                LOGGER.error("Failed to create modelled controls", (Throwable)e);
            }
        }
    }

    @Override
    protected void createControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        this.body = body;
        site.getPage().isPartVisible((IWorkbenchPart)this);
        this.doCreateControls(true);
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        this.getSite().getPage().addPartListener((IPartListener2)this);
    }

    protected void inputChanged(IWorkbenchPart provider, Object input) {
        LOGGER.trace("inputChanged( {}, {} )", (Object)provider, input);
        if (provider == this) {
            return;
        }
        this.applySessionContext(this.getSessionContext());
    }

    @Override
    public void setFocus() {
        if (this.root != null && !this.root.isNodeDisposed()) {
            this.root.setFocus();
        }
    }

    public void setVisible(boolean value) {
        if (this.root != null && !this.root.isNodeDisposed()) {
            this.root.setVisible(value);
        }
    }

    @Override
    public void dispose() {
        IWorkbenchPage page;
        this.disposeRuntime(this.runtime);
        IWorkbenchPartSite site = this.getSite();
        if (site != null && (page = site.getPage()) != null) {
            page.removePartListener((IPartListener2)this);
        }
        if (this.root != null) {
            this.root.cleanup();
            this.root = null;
        }
        if (this.loader != null) {
            this.loader.dispose();
            this.loader = null;
        }
        if (this.support != null) {
            this.support.dispose();
            this.support = null;
        }
        super.dispose();
    }

    protected void disposeRuntime(Resource runtime) {
        final Resource rt = this.runtime;
        this.runtime = null;
        if (rt == null) {
            return;
        }
        try {
            Simantics.getSession().sync((WriteInterface)new WriteRequest((VirtualGraph)Simantics.getSession().getService(VirtualGraph.class)){

                public void perform(WriteGraph graph) throws DatabaseException {
                    RemoverUtil.remove((WriteGraph)graph, (Resource)rt);
                }
            });
        }
        catch (DatabaseException | RuntimeDatabaseException e) {
            LOGGER.error("Failed to dispose of the modelled widget support runtime scenegraph", e);
        }
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (((Object)((Object)this)).equals(part)) {
            // empty if block
        }
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (((Object)((Object)this)).equals(part)) {
            this.clearExisting();
        }
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (((Object)((Object)this)).equals(part)) {
            this.createControlsIfNecessary(false);
        }
    }

    private void createControlsIfNecessary(boolean forceContainerRepaint) {
        this.reallyClearExisting = false;
        if (this.loader == null) {
            this.doCreateControls(true);
            this.body.layout(true);
            if (forceContainerRepaint) {
                this.container.layout(true);
                Point size = this.container.getSize();
                this.container.redraw(0, 0, size.x, size.y, true);
                this.container.update();
            }
        }
    }

    private void clearExisting() {
        Display.getCurrent().timerExec(30000, this.clearExisting);
        this.reallyClearExisting = true;
    }

    @Override
    protected IPropertyPage getPropertyPage() {
        return null;
    }
}

