package org.simantics.views.swt;

import java.util.Collections;
import java.util.Map;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.primitiverequest.PossibleObject;
import org.simantics.db.common.primitiverequest.RelatedValue2;
import org.simantics.db.common.primitiverequest.ResourceByURI;
import org.simantics.db.common.primitiverequest.SingleObject;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.loader.ScenegraphVariable;
import org.simantics.scenegraph.ontology.ScenegraphResources;
import org.simantics.utils.threads.SWTThread;
import org.simantics.views.ontology.ViewsResources;
import org.simantics.views.swt.client.base.SWTRoot;

/**
 * @author Tuukka Lehtonen
 */
public class ModelledDialogs {

	public static void scheduleMessage(final String uri) {
		scheduleMessage(uri, Collections.<String, Variant>emptyMap());
	}

	public static void scheduleMessage(final String uri, final Map<String, Variant> parameters) {

		SWTThread.getThreadAccess().asyncExec(new Runnable() {

			@Override
			public void run() {
				openMessage(uri, parameters);
			}

		});

	}
	
	private static int getStyle(Resource type) throws DatabaseException {
		ViewsResources VIEWS = ViewsResources.getInstance(Simantics.getSession());
		if(VIEWS.MessageDialog_Type_Error.equals(type)) return MessageDialog.ERROR;
		else if(VIEWS.MessageDialog_Type_Information.equals(type)) return MessageDialog.INFORMATION;
		else if(VIEWS.MessageDialog_Type_Question.equals(type)) return MessageDialog.QUESTION;
		else if(VIEWS.MessageDialog_Type_QuestionWithCancel.equals(type)) return MessageDialog.QUESTION_WITH_CANCEL;
		else if(VIEWS.MessageDialog_Type_Confirm.equals(type)) return MessageDialog.CONFIRM;
		else if(VIEWS.MessageDialog_Type_Warning.equals(type)) return MessageDialog.WARNING;
		else throw new DatabaseException("MessageDialog model needs to define a dialog type");
	}
		
	
	public static int openMessage(final String uri) {
		return openMessage(uri, Collections.<String, Variant>emptyMap());
	}

	private static SWTRoot createCustomArea(final Resource customArea, final Map<String, Variant> parameters) throws DatabaseException {
		
		if(customArea == null) return null;

		final SWTViewLoaderProcess loader = new SWTViewLoaderProcess(null, null);
		
		Variable context = Simantics.getSession().sync(new WriteResultRequest<Variable>(Simantics.getSession().getService(VirtualGraph.class)) {

			@Override
			public Variable perform(WriteGraph graph) throws DatabaseException {

				Layer0 L0 = Layer0.getInstance(graph);
				ScenegraphResources SG = ScenegraphResources.getInstance(graph);
				Resource runtime = graph.newResource();
				graph.claim(runtime, L0.InstanceOf, null, SG.Runtime);
				Variable base = Variables.getVariable(graph, customArea);
				String uri = base.getURI(graph);
				graph.claimLiteral(runtime, SG.Runtime_HasVariable, uri, Bindings.STRING);

				return new ScenegraphVariable(base, customArea, runtime, loader.getRoot(), parameters);

			}

		});

		return loader.load(Simantics.getSession(), context);
		
	}
	
	public static int openMessage(final String uri, final Map<String, Variant> parameters) {

		//assert SWTThread.getThreadAccess().currentThreadAccess();
		
		try {

			Session session = Simantics.getSession();
			ViewsResources VIEWS = ViewsResources.getInstance(session);
			final Resource configuration = session.sync(new ResourceByURI(uri));
			final Resource typeResource = session.sync(new SingleObject(configuration, VIEWS.MessageDialog_HasType));
			final int type = getStyle(typeResource);
			final String dialogTitle = session.sync(new RelatedValue2<String>(configuration, VIEWS.MessageDialog_title, Bindings.STRING));
			final String dialogMessage = session.sync(new RelatedValue2<String>(configuration, VIEWS.MessageDialog_message, Bindings.STRING));
			final String[] buttonLabels = session.sync(new RelatedValue2<String[]>(configuration, VIEWS.MessageDialog_buttonLabels, Bindings.STRING_ARRAY));
			final Integer defaultButton = session.sync(new RelatedValue2<Integer>(configuration, VIEWS.MessageDialog_defaultButton, Bindings.INTEGER));
			final Resource customArea = session.sync(new PossibleObject(configuration, VIEWS.MessageDialog_HasCustomArea));

			final SWTRoot root = createCustomArea(customArea, parameters);

			class Dialog extends MessageDialog {

				public Dialog() {
					super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 
							dialogTitle, null, 
							dialogMessage, 
							type, buttonLabels, defaultButton);
				}

				@Override
				protected boolean isResizable() {
					return true;
				}

				@Override
				protected Control createCustomArea(Composite parent) {
					if(root != null) {
						Composite customArea = new Composite(parent, SWT.NONE);
						customArea.setLayout(new GridLayout());
						GridDataFactory.fillDefaults().grab(true, true).minSize(50, 50).applyTo(customArea);
						root.createControls(customArea);
						return customArea;
					} else {
						return super.createCustomArea(parent);
					}
				}

			}

			return new Dialog().open();

		} catch (DatabaseException e) {
			Logger.defaultLogError(e);
		}
		
		return -1;

	}
	
	
	

}
