/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.views.swt.client.base;

import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Layout;
import org.simantics.browsing.ui.Column;
import org.simantics.views.ViewUtils;

public class SWTViewUtils {
    public static Layout toLayout(ViewUtils.GridLayoutBean bean) {
        GridLayout result = GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).margins(0, 0).spacing(0, 0).create();
        result.numColumns = bean.numColumns;
        result.horizontalSpacing = bean.horizontalSpacing;
        result.verticalSpacing = bean.verticalSpacing;
        result.marginLeft = bean.marginLeft;
        result.marginRight = bean.marginRight;
        result.marginTop = bean.marginTop;
        result.marginBottom = bean.marginBottom;
        return result;
    }

    public static Layout toLayout(ViewUtils.RowLayoutBean bean) {
        RowLayout result = RowLayoutFactory.fillDefaults().create();
        result.type = bean.type;
        result.spacing = bean.spacing;
        result.center = bean.center;
        result.fill = bean.fill;
        result.justify = bean.justify;
        result.pack = bean.pack;
        result.wrap = bean.wrap;
        result.marginLeft = bean.marginLeft;
        result.marginRight = bean.marginRight;
        result.marginTop = bean.marginTop;
        result.marginBottom = bean.marginBottom;
        return result;
    }

    public static GridData toGridData(ViewUtils.GridDataBean bean) {
        GridData result = new GridData(4, 4, true, false);
        result.horizontalSpan = bean.horizontalSpan;
        result.grabExcessHorizontalSpace = bean.grabExcessHorizontalSpace;
        result.grabExcessVerticalSpace = bean.grabExcessVerticalSpace;
        result.horizontalAlignment = bean.horizontalAlignment;
        result.verticalAlignment = bean.verticalAlignment;
        result.widthHint = bean.widthHint;
        result.heightHint = bean.heightHint;
        return result;
    }

    public static RowData toRowData(ViewUtils.RowDataBean bean) {
        return new RowData(bean.width, bean.height);
    }

    public static Layout toLayout(ViewUtils.LayoutBean layout) {
        if (layout instanceof ViewUtils.GridLayoutBean) {
            return SWTViewUtils.toLayout((ViewUtils.GridLayoutBean)layout);
        }
        if (layout instanceof ViewUtils.RowLayoutBean) {
            return SWTViewUtils.toLayout((ViewUtils.RowLayoutBean)layout);
        }
        throw new IllegalArgumentException("unrecognized layout: " + String.valueOf(layout));
    }

    public static Object toLayoutData(ViewUtils.LayoutDataBean layoutData) {
        if (layoutData instanceof ViewUtils.GridDataBean) {
            return SWTViewUtils.toGridData((ViewUtils.GridDataBean)layoutData);
        }
        if (layoutData instanceof ViewUtils.RowDataBean) {
            return SWTViewUtils.toRowData((ViewUtils.RowDataBean)layoutData);
        }
        throw new IllegalArgumentException("unrecognized layout data: " + String.valueOf(layoutData));
    }

    private static Column.Align getAlign(String alignment) {
        if ("LEFT".equals(alignment)) {
            return Column.Align.LEFT;
        }
        if ("CENTER".equals(alignment)) {
            return Column.Align.CENTER;
        }
        if ("RIGHT".equals(alignment)) {
            return Column.Align.RIGHT;
        }
        throw new IllegalArgumentException("Align should be either LEFT, CENTER or RIGHT (was " + alignment + ")");
    }

    public static Column toColumn(ViewUtils.ColumnBean bean) {
        Column.Align align = SWTViewUtils.getAlign(bean.alignment);
        return new Column(bean.key, bean.label, align, bean.width, bean.tooltip, bean.grab, bean.weight);
    }
}

