package org.simantics.views.swt.client.impl;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.widgets.Composite;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.utils.datastructures.map.Tuple;
import org.simantics.views.swt.client.base.SingleSWTViewNode;

public class SWTBrowser extends SingleSWTViewNode<Browser> {
	
	private static final long serialVersionUID = -2704760050046054447L;
	
	public String                     document;
	public Variable                   variable;
	public Function1<Object, Boolean> locationChanging;

	private Tuple                     lastAppliedParametrization;

	@Override
	public void reset() {
		super.reset();
		lastAppliedParametrization = null;
	}
	
	@Override
	public void createControls(Composite parent) {

		GridDataFactory.fillDefaults().grab(true, true).applyTo(parent);
		GridLayoutFactory.fillDefaults().applyTo(parent);

		control = new Browser(parent, style);
		GridDataFactory.fillDefaults().grab(true, true).applyTo(control);

		control.addLocationListener(new LocationListener() {
			@Override
			public void changing(LocationEvent event) {
				Function1<Object, Boolean> lc = locationChanging;
				if (lc != null)
					lc.apply(event);
			}
			@Override
			public void changed(LocationEvent event) {
			}
		});

		setProperties();

	}

	public void synchronizeVariable(Variable variable) {
		
	}

	public void synchronizeDocument(final String document) {
		
		if(document != null) {
			
			final Variable variable = SWTBrowser.this.variable;
			if (variable == null) {
				return;
			}

			Tuple checkParam = new Tuple(document, variable);
			if (checkParam.equals(lastAppliedParametrization))
				return;
			
			lastAppliedParametrization = checkParam;
				
			final Browser control = this.control;
			if (control == null)
				return;
			control.setText(document);
			
		}
	}

}
