/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.bytes;

import org.simantics.utils.bytes.LEInt;
import org.simantics.utils.strings.EString;

public class LEString {
    public static byte[] toBytes(String s) {
        int size = s.length();
        byte[] array = new byte[size + 4];
        LEInt.write(size, array);
        int i = 0;
        while (i < size) {
            array[i + 4] = (byte)s.charAt(i);
            ++i;
        }
        return array;
    }

    public static void write(String str, byte[] array, int offset) {
        int size = str.length();
        if (offset + 4 + size > array.length) {
            throw new IndexOutOfBoundsException();
        }
        LEInt.write(size, array, offset);
        int i = 0;
        while (i < size) {
            array[i + 4 + offset] = (byte)str.charAt(i);
            ++i;
        }
    }

    public static void write(String str, byte[] array) {
        int size = str.length();
        if (4 + size > array.length) {
            throw new IndexOutOfBoundsException();
        }
        LEInt.write(size, array);
        int i = 0;
        while (i < size) {
            array[i + 4] = (byte)str.charAt(i);
            ++i;
        }
    }

    public static String toString(byte[] array, int offset) {
        if (offset + 4 > array.length) {
            throw new IndexOutOfBoundsException();
        }
        int size = LEInt.toInt(array, offset);
        if (offset + 4 + size > array.length) {
            throw new IndexOutOfBoundsException();
        }
        char[] chars = new char[size];
        int i = 0;
        while (i < size) {
            chars[i] = (char)(array[i + 4 + offset] & 0xFF);
            ++i;
        }
        return new String(chars);
    }

    public static String toString(byte[] array) {
        if (4 > array.length) {
            throw new IndexOutOfBoundsException();
        }
        int size = LEInt.toInt(array);
        if (4 + size > array.length) {
            throw new IndexOutOfBoundsException();
        }
        char[] chars = new char[size];
        int i = 0;
        while (i < size) {
            chars[i] = (char)(array[i + 4] & 0xFF);
            ++i;
        }
        return new String(chars);
    }

    public static void main(String[] args) {
        String value = "STRING 01234\u0080\u0081\u00ff";
        int X = 500;
        System.out.println(X + " = " + LEString.intToHex(X, 4));
        byte[] array = LEString.toBytes(value);
        System.out.print(value);
        System.out.print(" = ");
        LEString.printByteArray(array);
        System.out.println();
        LEString.write(value, array);
        System.out.print(value);
        System.out.print(" = ");
        LEString.printByteArray(array);
        System.out.println();
        LEString.write(value, array, 0);
        System.out.print(value);
        System.out.print(" = ");
        LEString.printByteArray(array);
        System.out.println();
        value = LEString.toString(array, 0);
        LEString.printByteArray(array);
        System.out.print(" = ");
        System.out.print(value);
        System.out.println();
        value = LEString.toString(array);
        LEString.printByteArray(array);
        System.out.print(" = ");
        System.out.print(value);
        System.out.println();
        array = LEString.toBytes(value);
        System.out.print(value);
        System.out.print(" = ");
        LEString.printByteArray(array);
        System.out.println();
    }

    public static String intToHex(int value, int decimals) {
        Object result = "";
        int i = 0;
        while (i < decimals) {
            result = EString.HEX_VALUES[value & 0xF] + (String)result;
            result = EString.HEX_VALUES[value >> 4 & 0xF] + (String)result;
            value >>= 8;
            ++i;
        }
        return result;
    }

    public static void printByteArray(byte[] array) {
        int i = 0;
        while (i < array.length) {
            System.out.print(array[i] & 0xFF);
            if (i < array.length - 1) {
                System.out.print(",");
            }
            ++i;
        }
    }
}

