/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.jface;

import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;

public class FontCellEditor
extends DialogCellEditor {
    private Label fontLabel;

    public FontCellEditor() {
    }

    public FontCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    public FontCellEditor(Composite parent) {
        super(parent);
    }

    protected Control createContents(Composite cell) {
        this.fontLabel = new Label(cell, 16384);
        Color bg = cell.getBackground();
        this.fontLabel.setBackground(bg);
        return this.fontLabel;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        FontDialog fontDialog = new FontDialog(cellEditorWindow.getShell());
        FontData fontData = (FontData)this.getValue();
        if (fontData != null) {
            fontDialog.setFontList(new FontData[]{fontData});
        }
        return fontDialog.open();
    }

    protected void updateContents(Object value) {
        FontData fontData = (FontData)value;
        if (fontData == null) {
            this.fontLabel.setText("select font...");
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(fontData.getName());
        sb.append(", " + fontData.getHeight());
        if ((fontData.getStyle() & 1) > 0) {
            sb.append(", Bold");
        }
        if ((fontData.getStyle() & 2) > 0) {
            sb.append(", Italic");
        }
        this.fontLabel.setText(sb.toString());
    }
}

