/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.color;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.simantics.utils.ui.color.Color;

public class ColorPool {
    private List<Color> colors = new ArrayList<Color>();

    public void addDefaultColors() {
        this.colors.add(new Color(0, 0, 255));
        this.colors.add(new Color(255, 0, 0));
        this.colors.add(new Color(0, 200, 0));
        this.colors.add(new Color(0, 0, 0));
    }

    public List<Color> getColors() {
        return this.colors;
    }

    public Color getColor(int index) {
        if (this.colors.size() == 0) {
            this.addDefaultColors();
        }
        while (this.colors.size() <= index) {
            this.newRandomColor();
        }
        return this.colors.get(index);
    }

    public int getSize() {
        return this.colors.size();
    }

    public void add(Color color) {
        this.colors.add(color);
    }

    public void setColor(int index, Color color) {
        this.colors.set(index, color);
    }

    public void clear() {
        this.colors.clear();
    }

    private Color newRandomColor() {
        ArrayList<Color> sortColors = new ArrayList<Color>();
        for (Color c : this.colors) {
            if (Float.isNaN(c.getH())) continue;
            sortColors.add(c);
        }
        if (sortColors.size() > 0) {
            Collections.sort(sortColors);
            Color duplicate = new Color((Color)sortColors.get(0));
            duplicate.setH(((Color)sortColors.get(0)).getH() + 360.0f);
            sortColors.add(duplicate);
            float maxDelta = 0.0f;
            int maxDeltaIndex = 0;
            int i = 0;
            while (i < sortColors.size() - 1) {
                float delta = ((Color)sortColors.get(i + 1)).getH() - ((Color)sortColors.get(i)).getH();
                if (delta > maxDelta) {
                    maxDelta = delta;
                    maxDeltaIndex = i;
                }
                ++i;
            }
            float newHue = ((Color)sortColors.get(maxDeltaIndex)).getH() + 0.5f * maxDelta;
            if (newHue > 360.0f) {
                newHue -= 360.0f;
            }
            Color randomColor = Color.getRandomHSV(0.5f, 0.5f);
            randomColor.setH(newHue);
            this.colors.add(randomColor);
            return randomColor;
        }
        Color randomColor = Color.getRandomHSV(0.5f, 0.5f);
        this.colors.add(randomColor);
        return randomColor;
    }
}

