/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.color;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;

public class Color
implements Comparable<Color> {
    private int r;
    private int g;
    private int b;
    private float h;
    private float s;
    private float v;

    public Color() {
        this.r = 255;
        this.g = 255;
        this.b = 255;
        this.updateHSV();
    }

    public Color(int r, int g, int b) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.updateHSV();
    }

    public Color(float h, float s, float v) {
        this.h = h;
        this.s = s;
        this.v = v;
        this.updateRGB();
    }

    public Color(double h, double s, double v) {
        this.h = (float)h;
        this.s = (float)s;
        this.v = (float)v;
        this.updateRGB();
    }

    public Color(RGB rgb) {
        this.r = rgb.red;
        this.g = rgb.green;
        this.b = rgb.blue;
        this.updateHSV();
    }

    public Color(Color color) {
        this.r = color.r;
        this.g = color.g;
        this.b = color.b;
        this.h = color.h;
        this.s = color.s;
        this.v = color.v;
    }

    public Color(java.awt.Color color) {
        this.r = color.getRed();
        this.g = color.getGreen();
        this.b = color.getBlue();
        this.updateHSV();
    }

    public Color(org.eclipse.swt.graphics.Color color) {
        this.r = color.getRed();
        this.g = color.getGreen();
        this.b = color.getBlue();
        this.updateHSV();
    }

    public int getR() {
        return this.r;
    }

    public int getB() {
        return this.b;
    }

    public int getG() {
        return this.g;
    }

    public float getH() {
        return this.h;
    }

    public float getS() {
        return this.s;
    }

    public float getV() {
        return this.v;
    }

    public Color getWhite() {
        return new Color(255, 255, 255);
    }

    public Color getBlack() {
        return new Color(0, 0, 0);
    }

    public Color getRed() {
        return new Color(255, 0, 0);
    }

    public Color getGreen() {
        return new Color(0, 255, 0);
    }

    public Color getBlue() {
        return new Color(0, 0, 255);
    }

    public static Color getRandom() {
        return new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0));
    }

    public static Color getRandomHSV(float minSaturation, float minValue) {
        float randS = (float)Math.random() * (1.0f - minSaturation) + minSaturation;
        float randV = (float)Math.random() * (1.0f - minValue) + minValue;
        return new Color((float)Math.random() * 360.0f, randS, randV);
    }

    public java.awt.Color getAWTColor() {
        return new java.awt.Color(this.r, this.g, this.b);
    }

    public org.eclipse.swt.graphics.Color getSWTColor(Device device) {
        return new org.eclipse.swt.graphics.Color(device, this.r, this.g, this.b);
    }

    public RGB getRgb() {
        return new RGB(this.r, this.g, this.b);
    }

    private void updateHSV() {
        float tr = (float)this.r / 255.0f;
        float tg = (float)this.g / 255.0f;
        float tb = (float)this.b / 255.0f;
        this.v = Math.max(tr, tg);
        this.v = Math.max(this.v, tb);
        float min = Math.min(tr, tg);
        min = Math.min(min, tb);
        float delta = this.v - min;
        this.s = this.v < 0.01f ? 0.0f : delta / this.v;
        if (this.s == 0.0f) {
            this.h = 0.0f;
        } else {
            this.h = tr == this.v ? 60.0f * ((tg - tb) / delta) : (tg == this.v ? 120.0f + 60.0f * ((tb - tr) / delta) : 240.0f + 60.0f * ((tr - tg) / delta));
            if (this.h < 0.0f) {
                this.h += 360.0f;
            }
        }
    }

    private int floatToInt(float v) {
        return (int)(v * 255.0f);
    }

    /*
     * Unable to fully structure code
     */
    private void updateRGB() {
        block10: {
            if (this.s != 0.0f) ** GOTO lbl7
            this.r = this.floatToInt(this.v);
            this.g = this.floatToInt(this.v);
            this.b = this.floatToInt(this.v);
            break block10;
lbl-1000:
            // 1 sources

            {
                this.h += 360.0f;
lbl7:
                // 2 sources

                ** while (this.h < 0.0f)
            }
lbl8:
            // 2 sources

            while (this.h >= 360.0f) {
                this.h -= 360.0f;
            }
            hi = (int)Math.floor(this.h / 60.0f);
            f = this.h / 60.0f - (float)hi;
            p = this.v * (1.0f - this.s);
            q = this.v * (1.0f - f * this.s);
            t = this.v * (1.0f - (1.0f - f) * this.s);
            switch (hi) {
                case 0: {
                    this.r = this.floatToInt(this.v);
                    this.g = this.floatToInt(t);
                    this.b = this.floatToInt(p);
                    break;
                }
                case 1: {
                    this.r = this.floatToInt(q);
                    this.g = this.floatToInt(this.v);
                    this.b = this.floatToInt(p);
                    break;
                }
                case 2: {
                    this.r = this.floatToInt(p);
                    this.g = this.floatToInt(this.v);
                    this.b = this.floatToInt(t);
                    break;
                }
                case 3: {
                    this.r = this.floatToInt(p);
                    this.g = this.floatToInt(q);
                    this.b = this.floatToInt(this.v);
                    break;
                }
                case 4: {
                    this.r = this.floatToInt(t);
                    this.g = this.floatToInt(p);
                    this.b = this.floatToInt(this.v);
                    break;
                }
                case 5: {
                    this.r = this.floatToInt(this.v);
                    this.g = this.floatToInt(p);
                    this.b = this.floatToInt(q);
                }
            }
        }
    }

    public int hashCode() {
        return this.r ^ this.g << 8 ^ this.b << 16;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Color)) {
            return false;
        }
        Color c = (Color)obj;
        return c.r == this.r && c.g == this.g && c.b == this.b;
    }

    @Override
    public int compareTo(Color arg0) {
        int d = (int)((this.h - arg0.h) * 10000.0f);
        if (d == 0 && (d = this.r - arg0.r) == 0 && (d = this.g - arg0.g) == 0) {
            d = this.b - arg0.b;
        }
        return d;
    }

    void setH(float h) {
        this.h = h;
    }
}

