/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;

public class SWTDPIUtil {
    private static boolean initialized = false;
    private static int swtZoom;
    private static boolean hasSwtScale;
    private static float fromSwtInternalScalingFactorF;
    private static double fromSwtInternalScalingFactorD;
    private static float toSwtInternalScalingFactorF;
    private static double toSwtInternalScalingFactorD;

    private static void initialize() {
        if (initialized) {
            return;
        }
        swtZoom = DPIUtil.autoScaleUp((int)100);
        hasSwtScale = swtZoom != 100;
        fromSwtInternalScalingFactorD = 100.0 / (double)swtZoom;
        toSwtInternalScalingFactorD = (double)swtZoom / 100.0;
        fromSwtInternalScalingFactorF = (float)fromSwtInternalScalingFactorD;
        toSwtInternalScalingFactorF = (float)toSwtInternalScalingFactorD;
        initialized = true;
    }

    private static Rectangle scale(float s, Rectangle r, Rectangle target) {
        if (s == 1.0f) {
            if (r == target) {
                return r;
            }
            if (target == null) {
                return new Rectangle(r.x, r.y, r.width, r.height);
            }
            target.x = r.x;
            target.y = r.y;
            target.width = r.width;
            target.height = r.height;
            return target;
        }
        if (target == null) {
            return new Rectangle(Math.round((float)r.x * s), Math.round((float)r.y * s), Math.round((float)r.width * s), Math.round((float)r.height * s));
        }
        target.x = Math.round((float)r.x * s);
        target.y = Math.round((float)r.y * s);
        target.width = Math.round((float)r.width * s);
        target.height = Math.round((float)r.height * s);
        return target;
    }

    private static Rectangle2D scale(double s, Rectangle2D r, Rectangle2D target) {
        if (s == 1.0) {
            if (r == target) {
                return r;
            }
            if (target == null) {
                return (Rectangle2D)r.clone();
            }
            target.setFrame(r);
            return target;
        }
        if (target == null) {
            target = (Rectangle2D)r.clone();
        }
        target.setFrame(r.getX() * s, r.getY() * s, r.getWidth() * s, r.getHeight() * s);
        return target;
    }

    private static double downscaleSwt0(double x) {
        return hasSwtScale ? x * fromSwtInternalScalingFactorD : x;
    }

    private static int downscaleToIntegerSwt0(double x) {
        return (int)(hasSwtScale ? (double)Math.round(x * fromSwtInternalScalingFactorD) : x);
    }

    private static int downscaleSwt0(int x) {
        return hasSwtScale ? (int)Math.round((double)x * fromSwtInternalScalingFactorD) : x;
    }

    private static double upscaleSwt0(double x) {
        return hasSwtScale ? x * toSwtInternalScalingFactorD : x;
    }

    private static int upscaleToIntegerSwt0(double x) {
        return (int)(hasSwtScale ? (double)Math.round(x * toSwtInternalScalingFactorD) : x);
    }

    private static int upscaleSwt0(int x) {
        return hasSwtScale ? (int)Math.round((double)x * toSwtInternalScalingFactorD) : x;
    }

    public static double downscaleSwt(double x) {
        SWTDPIUtil.initialize();
        return SWTDPIUtil.downscaleSwt0(x);
    }

    public static int downscaleSwt(int x) {
        SWTDPIUtil.initialize();
        return SWTDPIUtil.downscaleSwt0(x);
    }

    public static Point2D downscaleSwt(double x, double y) {
        SWTDPIUtil.initialize();
        if (!hasSwtScale) {
            return new Point2D.Double(x, y);
        }
        double s = fromSwtInternalScalingFactorD;
        return new Point2D.Double(x * s, y * s);
    }

    public static Point downscaleSwt(int x, int y) {
        SWTDPIUtil.initialize();
        return new Point(SWTDPIUtil.downscaleSwt0(x), SWTDPIUtil.downscaleSwt0(y));
    }

    public static Point2D downscaleSwt(Point2D p) {
        return SWTDPIUtil.downscaleSwt(p.getX(), p.getY());
    }

    public static Point downscaleSwtToInteger(Point2D p) {
        SWTDPIUtil.initialize();
        return new Point(SWTDPIUtil.downscaleToIntegerSwt0(p.getX()), SWTDPIUtil.downscaleToIntegerSwt0(p.getY()));
    }

    public static Rectangle2D downscaleSwt(Rectangle2D r, Rectangle2D target) {
        SWTDPIUtil.initialize();
        return SWTDPIUtil.scale(fromSwtInternalScalingFactorD, r, target);
    }

    public static Rectangle2D downscaleSwt(Rectangle2D r) {
        return SWTDPIUtil.downscaleSwt(r, null);
    }

    public static Rectangle downscaleSwt(Rectangle r, Rectangle target) {
        SWTDPIUtil.initialize();
        return SWTDPIUtil.scale(fromSwtInternalScalingFactorF, r, target);
    }

    public static Rectangle downscaleSwt(Rectangle r) {
        return SWTDPIUtil.downscaleSwt(r, null);
    }

    public static Rectangle downscaleSwtToInteger(Rectangle2D r) {
        SWTDPIUtil.initialize();
        return new Rectangle(SWTDPIUtil.downscaleToIntegerSwt0(r.getMinX()), SWTDPIUtil.downscaleToIntegerSwt0(r.getMinY()), SWTDPIUtil.downscaleToIntegerSwt0(r.getWidth()), SWTDPIUtil.downscaleToIntegerSwt0(r.getHeight()));
    }

    public static double upscaleSwt(double x) {
        SWTDPIUtil.initialize();
        return SWTDPIUtil.upscaleSwt0(x);
    }

    public static int upscaleSwt(int x) {
        SWTDPIUtil.initialize();
        return SWTDPIUtil.upscaleSwt0(x);
    }

    public static Point2D upscaleSwt(double x, double y) {
        SWTDPIUtil.initialize();
        if (!hasSwtScale) {
            return new Point2D.Double(x, y);
        }
        double s = toSwtInternalScalingFactorD;
        return new Point2D.Double(x * s, y * s);
    }

    public static Point upscaleSwt(int x, int y) {
        SWTDPIUtil.initialize();
        return new Point(SWTDPIUtil.upscaleSwt0(x), SWTDPIUtil.upscaleSwt0(y));
    }

    public static Point2D upscaleSwt(Point2D p) {
        SWTDPIUtil.initialize();
        return hasSwtScale && p != null ? SWTDPIUtil.upscaleSwt(p.getX(), p.getY()) : p;
    }

    public static Point upscaleSwtToInteger(Point2D p) {
        SWTDPIUtil.initialize();
        return new Point(SWTDPIUtil.upscaleToIntegerSwt0(p.getX()), SWTDPIUtil.upscaleToIntegerSwt0(p.getY()));
    }

    public static Point upscaleSwt(Point p) {
        SWTDPIUtil.initialize();
        return hasSwtScale && p != null ? SWTDPIUtil.upscaleSwt(p.x, p.y) : p;
    }

    public static Rectangle2D upscaleSwt(Rectangle2D r, Rectangle2D target) {
        SWTDPIUtil.initialize();
        return SWTDPIUtil.scale(toSwtInternalScalingFactorD, r, target);
    }

    public static Rectangle upscaleSwt(Rectangle r, Rectangle target) {
        SWTDPIUtil.initialize();
        return SWTDPIUtil.scale(toSwtInternalScalingFactorF, r, target);
    }

    public static Rectangle2D upscaleSwt(Rectangle2D r) {
        return SWTDPIUtil.upscaleSwt(r, null);
    }

    public static Rectangle upscaleSwt(Rectangle r) {
        return SWTDPIUtil.upscaleSwt(r, null);
    }

    public static Rectangle upscaleSwtToInteger(Rectangle2D r) {
        return new Rectangle(SWTDPIUtil.upscaleToIntegerSwt0(r.getMinX()), SWTDPIUtil.upscaleToIntegerSwt0(r.getMinY()), SWTDPIUtil.upscaleToIntegerSwt0(r.getWidth()), SWTDPIUtil.upscaleToIntegerSwt0(r.getHeight()));
    }
}

