/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui;

import org.eclipse.swt.widgets.Display;

public abstract class DelayRunnable
implements Runnable {
    private static final int DEFAULT_REFRESH_DELAY_MS = 500;
    private int refreshDelay;
    private volatile boolean scheduled = false;
    private Display display;
    private Runnable timerSync = new Runnable(){

        @Override
        public void run() {
            DelayRunnable.this.display.timerExec(DelayRunnable.this.refreshDelay, (Runnable)DelayRunnable.this);
        }
    };

    public DelayRunnable(Display display) {
        this(display, 500);
    }

    public DelayRunnable(Display display, int refreshDelay) {
        this.display = display;
        this.refreshDelay = refreshDelay;
    }

    protected void release() {
        this.scheduled = false;
    }

    public boolean isScheduled() {
        return this.scheduled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleRefresh() {
        DelayRunnable delayRunnable = this;
        synchronized (delayRunnable) {
            if (this.scheduled) {
                return;
            }
            this.scheduled = true;
        }
        this.display.asyncExec(this.timerSync);
    }

    @Override
    public void run() {
        this.release();
        this.perform();
    }

    public void perform() {
    }
}

