/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.workbench;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;

/**
 * @author Tuukka Lehtonen
 */
public final class IAdaptableUtils {

    public static IAdaptable getAdaptable(String factoryId, IMemento memento) {
        IElementFactory factory = PlatformUI.getWorkbench().getElementFactory(factoryId);
        if (factory == null)
            return null;
        return factory.createElement(memento);
    }

    @SuppressWarnings("unchecked")
    public static <T> T adapt(String factoryId, IMemento memento, Class<T> clazz) {
        IAdaptable adaptable = getAdaptable(factoryId, memento);
        if (adaptable == null)
            return null;
        return (T) adaptable.getAdapter(clazz);
    }

}
