package org.simantics.utils.ui.nebula;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

/**
 * Combined version of
 *    org.eclipse.nebula.widgets.opal.commons.SelectionListenerUtil.
 *    org.eclipse.nebula.widgets.opal.commons.ReflectionUtils.
 * 
 * THis exists only to avoid dependency to org.eclipse.nebula.widgets.opal.commons.
 * 
 * @author MarkoLuukkainen
 *
 */
public class SelectionListenerUtil {
	/**
	 * Add a <code>SelectionListener</code> to a given Control
	 * 
	 * @param control control on which the selection listener is added
	 * @param listener listener to add
	 */
	public static void addSelectionListener(final Control control, final SelectionListener listener) {
		if (listener == null) {
			SWT.error(SWT.ERROR_NULL_ARGUMENT);
		}
		TypedListener typedListener = new TypedListener(listener);
		control.addListener(SWT.Selection, typedListener);
	}

	/**
	 * Remove a <code>SelectionListener</code> of a given Control
	 * 
	 * @param control control on which the selection listener is removed
	 * @param listener listener to remove
	 */
	public static void removeSelectionListener(final Control control, final SelectionListener listener) {
		if (listener == null) {
			SWT.error(SWT.ERROR_NULL_ARGUMENT);
		}
		final Listener[] listeners = control.getListeners(SWT.Selection);
		for (Listener l : listeners) {
			if (l instanceof TypedListener) {
				TypedListener typedListener = (TypedListener) l;
				if (typedListener.getEventListener() == listener) {
					callMethod(control, "removeListener", SWT.Selection, ((TypedListener) l).getEventListener());
					return;
				}
			}
		}
	}

	/**
	 * Fire the selection listeners of a given control
	 *
	 * @param control the control that fires the event
	 * @param sourceEvent mouse event
	 * @return true if the selection could be changed, false otherwise
	 */
	public static boolean fireSelectionListeners(final Control control, final Event sourceEvent) {
		for (final Listener listener : control.getListeners(SWT.Selection)) {
			final Event event = new Event();

			event.button = sourceEvent==null?1:sourceEvent.button;
			event.display = control.getDisplay();
			event.item = null;
			event.widget = control;
			event.data = sourceEvent == null ? null : sourceEvent.data;
			event.time = sourceEvent == null ? 0 : sourceEvent.time;
			event.x = sourceEvent == null ? 0 : sourceEvent.x;
			event.y = sourceEvent == null ? 0 : sourceEvent.y;
			event.type = SWT.Selection;

			listener.handleEvent(event);
			if (!event.doit) {
				return false;
			}
		}
		return true;
	}
	
	public static Object callMethod(final Object object, final String methodName, final Object... args) {
		if (object == null) {
			return null;
		}
		final Class<?>[] array = new Class<?>[args == null ? 0 : args.length];
		int index = 0;
		if (args != null) {
			for (final Object o : args) {
				array[index++] = o == null ? Object.class : o.getClass();
			}
		}

		return callMethodWithClassType(object, methodName, array, args);
	}
	
	private static Object callMethodWithClassType(final Object object, final String methodName, final Class<?>[] array, final Object... args) {
		Class<?> currentClass = object.getClass();
		Method method = null;
		while (currentClass != null) {
			try {
				method = currentClass.getDeclaredMethod(methodName, array);
				break;
			} catch (final NoSuchMethodException nsme) {
				currentClass = currentClass.getSuperclass();
			}
		}

		try {
			method.setAccessible(true);
			return method.invoke(object, args);
		} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
			e.printStackTrace();
			return null;
		}
	}
}