/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.gfx.clipboard.streams;

import java.io.IOException;
import java.io.InputStream;

import org.simantics.utils.ui.gfx.clipboard.headers.BitmapFileHeader;


/**
 * Adds WIN32 API BITMAPFILEHEADER into the beginning of stream 
 * 
 * @author Marko Luukkainen
 *
 */
public class AddBitmapHeaderInputStream extends InputStream{
    private InputStream iStream;
    private int readBytes = 0;
    private byte[] header;
    
    public AddBitmapHeaderInputStream(InputStream iStream) {
        this.iStream = iStream;
        BitmapFileHeader bfHeader = new BitmapFileHeader();
        header = bfHeader.getBytes();
    }
    
    @Override
    public int read() throws IOException {
        if (readBytes < header.length) {
            return 0xff & header[readBytes++];
        }
        return iStream.read();
    }
}
