/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 *
 * @author Toni Kalajainen
 */
package org.simantics.utils.ui.color;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ColorGradientDialog extends Dialog {

    ColorGradientComposite composite;
    ColorGradient value;
    
    protected ColorGradientDialog(Shell parentShell, ColorGradient initialValue) {
        super(parentShell);
        setShellStyle( getShellStyle() | SWT.RESIZE );        
        value = new ColorGradient(initialValue);
    }
    
    @Override
    protected Point getInitialSize() {
        return new Point(400, 400);
    }
    
    @Override
    protected Control createDialogArea(Composite parent) {
        composite = new ColorGradientComposite(parent, 0);
        GridData childData = new GridData(GridData.FILL_BOTH);
        composite.setLayoutData(childData);        
        composite.setGradient(value);
        return composite;
    }
    
    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        // create OK and Cancel buttons by default
        createButton(parent, IDialogConstants.OK_ID,
                IDialogConstants.OK_LABEL, true);
        createButton(parent, IDialogConstants.CANCEL_ID,
                IDialogConstants.CANCEL_LABEL, false);
    }
    
    @Override
    protected void okPressed() {
        value = composite.getGradient();
        super.okPressed();
    }
    
    public ColorGradient getGradient() {
        return value;
    }

    public void setGradient(ColorGradient gradient) {
        this.value = gradient;
    }
    
}
