/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.threads.ua;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import org.simantics.utils.threads.ua.AbstractState;
import org.simantics.utils.threads.ua.AbstractWorkMonitor;
import org.simantics.utils.threads.ua.ExecutorState;
import org.simantics.utils.threads.ua.IStatefulObject;
import org.simantics.utils.threads.ua.StateListener;
import org.simantics.utils.threads.ua.StatefulExecutor;
import org.simantics.utils.threads.ua.WorkMonitor;
import org.simantics.utils.threads.ua.WorkState;
import org.simantics.utils.threads.ua.Worker;
import org.simantics.utils.threads.ua.WorkerClosedException;

public class ThreadPool
extends AbstractState<ExecutorState, RuntimeException>
implements Worker,
StatefulExecutor {
    private static final ThreadGroup THREADGROUP = new ThreadGroup("ThreadPool");
    private static final ThreadFactory FACTORY = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(THREADGROUP, r, "WorkerThread");
            t.setDaemon(true);
            return t;
        }
    };
    LinkedList<WorkImpl> queue = new LinkedList();
    Semaphore s = new Semaphore(0);
    Map<Thread, ThreadMode> threads = new HashMap<Thread, ThreadMode>();
    int spawnOnDemandLimit = 0;
    static ThreadPool INSTANCE;
    ThreadFactory threadFactory = FACTORY;
    Runnable residentRun = new Runnable(){

        @Override
        public void run() {
            ThreadPool.this.work(true);
        }
    };
    Runnable tempRun = new Runnable(){

        @Override
        public void run() {
            ThreadPool.this.work(false);
        }
    };

    public static synchronized ThreadPool getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ThreadPool(Runtime.getRuntime().availableProcessors());
        }
        return INSTANCE;
    }

    public ThreadPool() {
        super(ExecutorState.Active);
    }

    public ThreadPool(int maxNumberOfTemporaryThreads) {
        super(ExecutorState.Active);
        this.setSpawnOnDemandLimit(maxNumberOfTemporaryThreads);
    }

    public synchronized int getWorkingThreadCount() {
        int result = 0;
        for (ThreadMode m : this.threads.values()) {
            if (m == ThreadMode.Interrupted) continue;
            ++result;
        }
        return result;
    }

    public void setSpawnOnDemandLimit(int limit) {
        this.spawnOnDemandLimit = limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void work(boolean stayResident) {
        Thread t = Thread.currentThread();
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            this.threads.put(t, stayResident ? ThreadMode.Resident : ThreadMode.Temporary);
        }
        while (true) {
            Object mode;
            threadPool = this;
            synchronized (threadPool) {
                mode = this.getThreadMode(t);
                ExecutorState state = (ExecutorState)((Object)this.getState());
                if (mode == ThreadMode.Temporary && (this.isEmpty() || !ExecutorState.WORKING_STATES.contains((Object)state))) {
                    mode = ThreadMode.Interrupted;
                }
                if (mode == null || mode == ThreadMode.Interrupted) {
                    break;
                }
                if (state == ExecutorState.Terminated) {
                    break;
                }
                if (state == ExecutorState.Paused) {
                    if (mode == ThreadMode.Temporary) {
                        break;
                    }
                    if (mode == ThreadMode.Resident) {
                        try {
                            this.waitForState(ExecutorState.NON_PAUSED_STATES);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                }
            }
            try {
                WorkImpl work;
                this.s.acquire();
                mode = this;
                synchronized (mode) {
                    work = this.queue.removeFirst();
                }
                try {
                    work.setState(WorkState.Working);
                    work.getRunnable().run();
                    work.setState(WorkState.Complete);
                }
                catch (RuntimeException e) {
                    work.setError(e);
                    work.setState(WorkState.Error);
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        boolean goToShutdown = false;
        ThreadPool threadPool2 = this;
        synchronized (threadPool2) {
            this.threads.remove(t);
            goToShutdown = this.getState() == ExecutorState.Shutdown && this.threads.isEmpty() && this.queue.isEmpty();
        }
        if (goToShutdown) {
            super.setState(ExecutorState.Terminated);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread newThread(boolean stayResident) {
        Thread t = new Thread(THREADGROUP, stayResident ? this.residentRun : this.tempRun, "WorkerThread");
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            this.threads.put(t, stayResident ? ThreadMode.Resident : ThreadMode.Temporary);
        }
        t.start();
        return t;
    }

    public synchronized ThreadMode getThreadMode(Thread t) {
        return this.threads.get(t);
    }

    public synchronized void setMode(Thread t, ThreadMode tm) {
        if (t == null || tm == null) {
            throw new IllegalArgumentException();
        }
        ThreadMode oldMode = this.threads.get(t);
        if (oldMode == tm) {
            return;
        }
        this.threads.put(t, tm);
        if (tm == ThreadMode.Interrupted) {
            t.interrupt();
        }
        if (tm == ThreadMode.Temporary && this.isEmpty()) {
            t.interrupt();
        }
    }

    public synchronized boolean isEmpty() {
        return this.queue.isEmpty();
    }

    void interrupt(Thread t) {
        t.interrupt();
    }

    public synchronized boolean remove(WorkImpl r) {
        return this.queue.remove(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkMonitor asyncExec(Runnable runnable, StateListener<WorkState> listener) throws WorkerClosedException {
        WorkImpl w = null;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            if (!ExecutorState.ACCEPTS_WORK_STATES.contains(this.getState())) {
                throw new WorkerClosedException();
            }
            w = new WorkImpl(runnable);
            if (listener != null) {
                w.addStateListener(listener);
            }
            this.queue.add(w);
            this.spawnTempThreads();
        }
        this.s.release();
        return w;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setState(ExecutorState state) {
        if (this.getState() == ExecutorState.Terminated) {
            return false;
        }
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            block7: {
                if (state != ExecutorState.Terminated && state != ExecutorState.Shutdown) break block7;
                if (this.threads.isEmpty() && this.queue.isEmpty()) {
                    super.setState(ExecutorState.Shutdown);
                    super.setState(ExecutorState.Terminated);
                } else {
                    super.setState(ExecutorState.Shutdown);
                }
                return true;
            }
        }
        return super.setState(state);
    }

    public synchronized void cancelAll(boolean mayInterrupt) {
        for (WorkMonitor workMonitor : this.queue) {
            workMonitor.cancel(mayInterrupt);
        }
        this.queue.clear();
    }

    @Override
    protected void onStateTransition(ExecutorState oldState, ExecutorState newState) {
        if (!ExecutorState.WORKING_STATES.contains((Object)oldState) && ExecutorState.WORKING_STATES.contains((Object)newState)) {
            this.spawnTempThreads();
        }
    }

    private synchronized void spawnTempThreads() {
        if (!ExecutorState.WORKING_STATES.contains(this.getState())) {
            return;
        }
        if (this.spawnOnDemandLimit > 0) {
            int workers = this.getWorkingThreadCount();
            int n = this.spawnOnDemandLimit - workers;
            int i = 0;
            while (i < n) {
                this.newThread(false);
                ++i;
            }
        }
    }

    @Override
    public synchronized void getQueuedWork(Collection<WorkMonitor> result) {
        result.addAll(this.queue);
    }

    public static void main(String[] args) throws InterruptedException {
        int j;
        ThreadPool pool = new ThreadPool(2);
        pool.addStateListener(new StateListener<ExecutorState>(){

            @Override
            public void onStateTransition(IStatefulObject<ExecutorState, ?> monitor, ExecutorState oldState, ExecutorState newState) {
                System.out.println("Worker State: " + String.valueOf((Object)newState));
            }
        });
        StateListener<WorkState> l = new StateListener<WorkState>(){

            @Override
            public void onStateTransition(IStatefulObject<WorkState, ?> monitor, WorkState oldState, WorkState newState) {
                System.out.println("Work (" + String.valueOf(monitor) + "): " + String.valueOf((Object)newState));
            }
        };
        Runnable[] r = new Runnable[10];
        WorkMonitor[] m = new WorkMonitor[10];
        int i = 0;
        while (i < r.length) {
            j = i;
            r[i] = new Runnable(){

                public String toString() {
                    return "" + j;
                }

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    System.out.println(j + " completed by " + String.valueOf(Thread.currentThread()));
                }
            };
            ++i;
        }
        i = 0;
        Runnable[] runnableArray = r;
        int n = r.length;
        int n2 = 0;
        while (n2 < n) {
            Runnable rr = runnableArray[n2];
            m[i++] = pool.asyncExec(rr, l);
            ++n2;
        }
        j = 2;
        while (j < 8) {
            m[j].cancel(false);
            ++j;
        }
        pool.setState(ExecutorState.Terminated);
        m[9].waitForState(EnumSet.of(WorkState.Complete));
        System.out.println("fin");
    }

    public void setThreadFactory(ThreadFactory factory) {
        this.threadFactory = factory;
    }

    @Override
    public void execute(Runnable command) {
        this.asyncExec(command, null);
    }

    public static enum ThreadMode {
        Resident,
        Temporary,
        Interrupted;

    }

    public class WorkImpl
    extends AbstractWorkMonitor {
        public WorkImpl(Runnable r) {
            super(r);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterrupt) {
            if (mayInterrupt) {
                throw new RuntimeException("NOT IMPLEMENTED");
            }
            ThreadPool threadPool = ThreadPool.this;
            synchronized (threadPool) {
                WorkState s = (WorkState)((Object)this.getState());
                if (s == WorkState.Ready) {
                    return ThreadPool.this.remove(this);
                }
            }
            return false;
        }

        @Override
        public boolean setState(WorkState state) {
            return super.setState(state);
        }
    }
}

