/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.threads.logger;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.simantics.utils.threads.logger.ThreadLogger;

public class ThreadLogVisualizer {
    public static final long DISCARD_LIMIT = 2000000L;
    public static final long COLUMN_WIDTH = 1000000000L;
    final int onlyOneThread = -1;
    final String[] colors = new String[]{"#53c0a7", "#ca49a1", "#64b74e", "#a159ca", "#b6b345", "#656bc5", "#da943b", "#5e99d3", "#d1592b", "#418a53", "#e16182", "#777d34", "#ca89ca", "#b7754c", "#9e4b6b", "#cb4347"};
    ArrayList<Task> tasks = new ArrayList();
    private Map<Long, Task> compositeTasks = new HashMap<Long, Task>();

    private boolean acceptThread(long threadId) {
        return true;
    }

    public void read(DataInput input) {
        try {
            try {
                while (true) {
                    Task t;
                    String taskName = input.readUTF();
                    long threadId = input.readLong();
                    long beginTime = input.readLong();
                    long endTime = input.readLong();
                    if (!this.acceptThread(threadId)) continue;
                    if (endTime - beginTime > 2000000L) {
                        this.tasks.add(new Task(taskName, threadId, beginTime, endTime));
                        t = this.compositeTasks.remove(threadId);
                        if (t == null || t.endTime - t.beginTime <= 2000000L) continue;
                        this.tasks.add(new Task(t.combined + " small tasks", t.threadId, t.beginTime, t.endTime));
                        continue;
                    }
                    t = this.compositeTasks.get(threadId);
                    if (t == null) {
                        t = new Task("", threadId, beginTime, endTime);
                        this.compositeTasks.put(threadId, t);
                    }
                    if (beginTime - t.endTime > 2000000L) {
                        this.tasks.add(new Task(t.combined + " small tasks", t.threadId, t.beginTime, t.endTime));
                        t = new Task("", threadId, beginTime, endTime);
                        this.compositeTasks.put(threadId, t);
                    }
                    t.endTime = endTime;
                    ++t.combined;
                    if (t.endTime - t.beginTime <= 2000000L) continue;
                    this.tasks.add(new Task(t.combined + " small tasks", t.threadId, t.beginTime, t.endTime));
                    this.compositeTasks.remove(threadId);
                }
            }
            catch (EOFException eOFException) {
            }
        }
        catch (IOException iOException) {}
        Collections.sort(this.tasks);
    }

    public void visualize3(PrintStream s) {
        long minTime = Long.MAX_VALUE;
        long maxTime = Long.MIN_VALUE;
        ArrayList<Lane> lanes = new ArrayList<Lane>();
        int laneId = 0;
        for (Task task : this.tasks) {
            Lane lane;
            minTime = Math.min(minTime, task.beginTime);
            maxTime = Math.max(maxTime, task.endTime);
            int seek = laneId - 1;
            while (seek >= 0) {
                if (((Lane)lanes.get((int)seek)).nextTime >= task.beginTime) break;
                laneId = seek--;
            }
            if (laneId < lanes.size()) {
                lane = (Lane)lanes.get(laneId);
            } else {
                lane = new Lane();
                lanes.add(lane);
            }
            lane.tasks.add(task);
            lane.nextTime = Math.max(task.endTime, task.beginTime + 1000000000L);
            System.out.println(task.name + " -> " + laneId + "[" + task.beginTime + "-" + task.endTime + "]");
            ++laneId;
        }
        double timeScale = 1.0E-6;
        double rowHeight = 30.0;
        Locale locale = Locale.US;
        int row = lanes.size();
        s.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        s.println("<svg xmlns=\"http://www.w3.org/2000/svg\" overflow=\"visible\" version=\"1.1\">");
        long time = minTime;
        while (time < maxTime) {
            s.printf(locale, "<line x1=\"%f\" y1=\"%f\" x2=\"%f\" y2=\"%f\" stroke=\"grey\"/>\n", (double)(time - minTime) * timeScale, 0.0, (double)(time - minTime) * timeScale, (double)row * rowHeight);
            time += 1000000000L;
        }
        int r = 0;
        while (r < lanes.size()) {
            Lane lane = (Lane)lanes.get(r);
            for (Task task : lane.tasks) {
                s.printf(locale, "<line x1=\"%f\" y1=\"%f\" x2=\"%f\" y2=\"%f\" stroke=\"black\"/>\n", (double)(task.beginTime - minTime) * timeScale, (double)r * rowHeight, (double)(task.beginTime - minTime) * timeScale, (double)(r + 1) * rowHeight);
                s.printf(locale, "<rect x=\"%f\" y=\"%f\" width=\"%f\" height=\"%f\" fill=\"" + this.colors[(int)task.threadId & 0xF] + "\"/>\n", (double)(task.beginTime - minTime) * timeScale, (double)r * rowHeight, (double)(task.endTime - task.beginTime) * timeScale, rowHeight);
            }
            for (Task task : lane.tasks) {
                int time2 = (int)(1.0E-6 * (double)(task.endTime - task.beginTime));
                s.printf(locale, "<text x=\"%f\" y=\"%f\">%s</text>\n", (double)(task.endTime - minTime) * timeScale, ((double)r + 0.8) * rowHeight, Integer.toString(time2) + "ms: " + task.name);
            }
            ++r;
        }
        s.println("</svg>");
    }

    public void visualize2(PrintStream s) {
        long minTime = Long.MAX_VALUE;
        long maxTime = Long.MIN_VALUE;
        ArrayList<Lane> lanes = new ArrayList<Lane>();
        for (Task task : this.tasks) {
            Lane lane;
            minTime = Math.min(minTime, task.beginTime);
            maxTime = Math.max(maxTime, task.endTime);
            int laneId = 0;
            while (laneId < lanes.size()) {
                if (((Lane)lanes.get((int)laneId)).nextTime < task.beginTime) break;
                ++laneId;
            }
            if (laneId < lanes.size()) {
                lane = (Lane)lanes.get(laneId);
            } else {
                lane = new Lane();
                lanes.add(lane);
            }
            lane.tasks.add(task);
            lane.nextTime = Math.max(task.endTime, task.beginTime + 1000000000L);
            System.out.println(task.name + " -> " + laneId + "[" + task.beginTime + "-" + task.endTime + "]");
        }
        double timeScale = 5.0E-7;
        double rowHeight = 30.0;
        Locale locale = Locale.US;
        int row = lanes.size();
        s.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        s.println("<svg xmlns=\"http://www.w3.org/2000/svg\" overflow=\"visible\" version=\"1.1\">");
        long time = minTime;
        while (time < maxTime) {
            s.printf(locale, "<line x1=\"%f\" y1=\"%f\" x2=\"%f\" y2=\"%f\" stroke=\"grey\"/>\n", (double)(time - minTime) * timeScale, 0.0, (double)(time - minTime) * timeScale, (double)row * rowHeight);
            time += 1000000000L;
        }
        int r = 0;
        while (r < lanes.size()) {
            Lane lane = (Lane)lanes.get(r);
            for (Task task : lane.tasks) {
                s.printf(locale, "<line x1=\"%f\" y1=\"%f\" x2=\"%f\" y2=\"%f\" stroke=\"black\"/>\n", (double)(task.beginTime - minTime) * timeScale, (double)r * rowHeight, (double)(task.beginTime - minTime) * timeScale, (double)(r + 1) * rowHeight);
                s.printf(locale, "<rect x=\"%f\" y=\"%f\" width=\"%f\" height=\"%f\" fill=\"" + this.colors[(int)task.threadId & 0xF] + "\"/>\n", (double)(task.beginTime - minTime) * timeScale, (double)r * rowHeight, (double)(task.endTime - task.beginTime) * timeScale, rowHeight);
            }
            for (Task task : lane.tasks) {
                s.printf(locale, "<text x=\"%f\" y=\"%f\">%s</text>\n", (double)(task.endTime - minTime) * timeScale, ((double)r + 0.8) * rowHeight, task.name);
            }
            ++r;
        }
        s.println("</svg>");
    }

    public void visualize(PrintStream s) {
        int r;
        long minTime = Long.MAX_VALUE;
        long maxTime = Long.MIN_VALUE;
        HashMap<Long, Integer> threads = new HashMap<Long, Integer>();
        int row = 0;
        for (Task task : this.tasks) {
            minTime = Math.min(minTime, task.beginTime);
            maxTime = Math.max(maxTime, task.endTime);
            if (threads.containsKey(task.threadId)) continue;
            threads.put(task.threadId, row++);
        }
        double timeScale = 8.0E-8;
        double rowHeight = 60.0;
        Locale locale = Locale.US;
        int[] textPos = new int[row];
        s.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        s.println("<svg xmlns=\"http://www.w3.org/2000/svg\" overflow=\"visible\" version=\"1.1\">");
        long time = minTime;
        while (time < maxTime) {
            s.printf(locale, "<line x1=\"%f\" y1=\"%f\" x2=\"%f\" y2=\"%f\" stroke=\"grey\"/>\n", (double)(time - minTime) * timeScale, 0.0, (double)(time - minTime) * timeScale, (double)row * rowHeight);
            time += 1000000000L;
        }
        for (Task task : this.tasks) {
            r = (Integer)threads.get(task.threadId);
            s.printf(locale, "<line x1=\"%f\" y1=\"%f\" x2=\"%f\" y2=\"%f\" stroke=\"black\"/>\n", (double)(task.beginTime - minTime) * timeScale, (double)r * rowHeight, (double)(task.beginTime - minTime) * timeScale, (double)(r + 1) * rowHeight);
            s.printf(locale, "<rect x=\"%f\" y=\"%f\" width=\"%f\" height=\"%f\" fill=\"" + this.colors[(int)task.threadId & 0xF] + "\"/>\n", (double)(task.beginTime - minTime) * timeScale, (double)r * rowHeight, (double)(task.endTime - task.beginTime) * timeScale, rowHeight);
        }
        for (Task task : this.tasks) {
            r = (Integer)threads.get(task.threadId);
            Object[] objectArray = new Object[3];
            objectArray[0] = (double)(task.endTime - minTime) * timeScale;
            int n = r;
            int n2 = textPos[n];
            textPos[n] = n2 + 1;
            objectArray[1] = ((double)(r * 3 + n2 % 2) + 0.5) * rowHeight / 3.0;
            objectArray[2] = task.name;
            s.printf(locale, "<text x=\"%f\" y=\"%f\">%s</text>\n", objectArray);
        }
        s.println("</svg>");
    }

    public static void main(String[] args) {
        try {
            ThreadLogVisualizer visualizer = new ThreadLogVisualizer();
            visualizer.read(new DataInputStream(new FileInputStream(ThreadLogger.LOG_FILE)));
            visualizer.visualize3(new PrintStream(ThreadLogger.LOG_FILE + ".svg"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    class Lane {
        ArrayList<Task> tasks = new ArrayList();
        long nextTime = 0L;

        Lane() {
        }
    }

    class Task
    implements Comparable<Task> {
        String name;
        long beginTime;
        long endTime;
        long threadId;
        long combined = 0L;

        public Task(String name, long threadId, long beginTime, long endTime) {
            if (name.length() > 100) {
                name = name.substring(0, 99);
            }
            this.name = name;
            this.threadId = threadId;
            this.beginTime = beginTime;
            this.endTime = endTime;
        }

        @Override
        public int compareTo(Task o) {
            if (this.beginTime > o.beginTime) {
                return 1;
            }
            if (this.beginTime == o.beginTime) {
                return -1;
            }
            return -1;
        }
    }
}

