/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures.persistent;

import gnu.trove.procedure.TObjectProcedure;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;

public class ImmutableSet<T extends Comparable<T>> {
    static final ImmutableSet EMPTY = new EmptyImmutableSet();
    ImmutableSet<T> left;
    T key;
    ImmutableSet<T> right;
    boolean isBlack;

    protected ImmutableSet(ImmutableSet<T> left, T key, ImmutableSet<T> right, boolean isBlack) {
        this.left = left;
        this.right = right;
        this.key = key;
        this.isBlack = isBlack;
    }

    public ImmutableSet(T key) {
        this(EMPTY, key, EMPTY, false);
    }

    public static <T extends Comparable<T>> ImmutableSet<T> of(T ... array) {
        if (array.length == 0) {
            return EMPTY;
        }
        ImmutableSet<T> ret = new ImmutableSet<T>(array[0]);
        int i = 1;
        while (i < array.length) {
            ret = ret.add(array[i]);
            ++i;
        }
        return ret;
    }

    public static <T extends Comparable<T>> ImmutableSet<T> of(Collection<T> c) {
        Iterator<T> it = c.iterator();
        if (!it.hasNext()) {
            return EMPTY;
        }
        ImmutableSet<Comparable> ret = new ImmutableSet<Comparable>((Comparable)it.next());
        while (it.hasNext()) {
            ret = ret.add((Comparable)it.next());
        }
        return ret;
    }

    private ImmutableSet() {
    }

    public boolean contains(T obj) {
        int cmp = obj.compareTo(this.key);
        if (cmp < 0) {
            return this.left.contains(obj);
        }
        if (cmp > 0) {
            return this.right.contains(obj);
        }
        return true;
    }

    protected ImmutableSet<T> addRec(T obj) {
        int cmp = obj.compareTo(this.key);
        if (cmp < 0) {
            ImmutableSet<T> newLeft = this.left.addRec(obj);
            if (newLeft == this.left) {
                return this;
            }
            if (this.isBlack) {
                return ImmutableSet.balance(newLeft, this.key, this.right);
            }
            return ImmutableSet.red(newLeft, this.key, this.right);
        }
        if (cmp > 0) {
            ImmutableSet<T> newRight = this.right.addRec(obj);
            if (newRight == this.right) {
                return this;
            }
            if (this.isBlack) {
                return ImmutableSet.balance(this.left, this.key, newRight);
            }
            return ImmutableSet.red(this.left, this.key, newRight);
        }
        return this;
    }

    protected ImmutableSet<T> removeRec(T obj) {
        int cmp = obj.compareTo(this.key);
        if (cmp < 0) {
            ImmutableSet<T> newLeft = this.left.removeRec(obj);
            if (newLeft == null) {
                return null;
            }
            if (this.left.isBlack) {
                return ImmutableSet.balleft(newLeft, this.key, this.right);
            }
            return ImmutableSet.red(newLeft, this.key, this.right);
        }
        if (cmp > 0) {
            ImmutableSet<T> newRight = this.right.removeRec(obj);
            if (newRight == null) {
                return null;
            }
            if (this.right.isBlack) {
                return ImmutableSet.balright(this.left, this.key, newRight);
            }
            return ImmutableSet.red(this.left, this.key, newRight);
        }
        return ImmutableSet.append(this.left, this.right);
    }

    protected static <T extends Comparable<T>> ImmutableSet<T> append(ImmutableSet<T> a, ImmutableSet<T> b) {
        if (a == EMPTY) {
            return b;
        }
        if (b == EMPTY) {
            return a;
        }
        if (a.isBlack) {
            if (b.isBlack) {
                ImmutableSet<T> middle = ImmutableSet.append(a.right, b.left);
                if (middle.isBlack) {
                    return ImmutableSet.balleft(a.left, a.key, ImmutableSet.black(middle, b.key, b.right));
                }
                return ImmutableSet.red(ImmutableSet.black(a.left, a.key, middle.left), middle.key, ImmutableSet.black(middle.right, b.key, b.right));
            }
            return ImmutableSet.red(ImmutableSet.append(a, b.left), b.key, b.right);
        }
        if (b.isBlack) {
            return ImmutableSet.red(a.left, a.key, ImmutableSet.append(a.right, b));
        }
        ImmutableSet<T> middle = ImmutableSet.append(a.right, b.left);
        if (middle.isBlack) {
            return ImmutableSet.red(a.left, a.key, ImmutableSet.red(middle, b.key, b.right));
        }
        return ImmutableSet.red(ImmutableSet.red(a.left, a.key, middle.left), middle.key, ImmutableSet.red(middle.right, b.key, b.right));
    }

    public T getFirst() {
        if (this.left == EMPTY) {
            return this.key;
        }
        return this.left.getFirst();
    }

    private static <T extends Comparable<T>> ImmutableSet<T> balance(ImmutableSet<T> left, T key, ImmutableSet<T> right) {
        if (!left.isBlack) {
            if (!left.left.isBlack) {
                return ImmutableSet.red(ImmutableSet.toBlack(left.left), left.key, ImmutableSet.black(left.right, key, right));
            }
            if (!left.right.isBlack) {
                return ImmutableSet.red(ImmutableSet.black(left.left, left.key, left.right.left), left.right.key, ImmutableSet.black(left.right.right, key, right));
            }
        }
        if (!right.isBlack) {
            if (!right.left.isBlack) {
                return ImmutableSet.red(ImmutableSet.black(left, key, right.left.left), right.left.key, ImmutableSet.black(right.left.right, right.key, right.right));
            }
            if (!right.right.isBlack) {
                return ImmutableSet.red(ImmutableSet.black(left, key, right.left), right.key, ImmutableSet.toBlack(right.right));
            }
        }
        return ImmutableSet.black(left, key, right);
    }

    private static <T extends Comparable<T>> ImmutableSet<T> black(ImmutableSet<T> left, T key, ImmutableSet<T> right) {
        return new ImmutableSet<T>(left, key, right, true);
    }

    private static <T extends Comparable<T>> ImmutableSet<T> red(ImmutableSet<T> left, T key, ImmutableSet<T> right) {
        return new ImmutableSet<T>(left, key, right, false);
    }

    private static <T extends Comparable<T>> ImmutableSet<T> toBlack(ImmutableSet<T> tree) {
        if (tree.isBlack) {
            return tree;
        }
        return ImmutableSet.black(tree.left, tree.key, tree.right);
    }

    private static <T extends Comparable<T>> ImmutableSet<T> toRed(ImmutableSet<T> tree) {
        if (tree.isBlack) {
            return ImmutableSet.red(tree.left, tree.key, tree.right);
        }
        return tree;
    }

    private static <T extends Comparable<T>> ImmutableSet<T> balleft(ImmutableSet<T> left, T key, ImmutableSet<T> right) {
        if (left.isBlack) {
            if (right.isBlack) {
                return ImmutableSet.balance(left, key, ImmutableSet.toRed(right));
            }
            return ImmutableSet.red(ImmutableSet.black(left, key, right.left.left), right.left.key, ImmutableSet.balance(right.left.right, right.key, ImmutableSet.toRed(right.right)));
        }
        return ImmutableSet.red(ImmutableSet.toBlack(left), key, right);
    }

    private static <T extends Comparable<T>> ImmutableSet<T> balright(ImmutableSet<T> left, T key, ImmutableSet<T> right) {
        if (right.isBlack) {
            if (left.isBlack) {
                return ImmutableSet.balance(ImmutableSet.toRed(left), key, right);
            }
            return ImmutableSet.red(ImmutableSet.balance(ImmutableSet.toRed(left.left), left.key, left.right.left), left.right.key, ImmutableSet.black(left.right.right, key, right));
        }
        return ImmutableSet.red(left, key, ImmutableSet.toBlack(right));
    }

    public ImmutableSet<T> add(T obj) {
        ImmutableSet<T> tree = this.addRec(obj);
        tree.isBlack = true;
        return tree;
    }

    public ImmutableSet<T> remove(T obj) {
        ImmutableSet<T> tree = this.removeRec(obj);
        if (tree == null) {
            return this;
        }
        if (tree.isBlack) {
            return tree;
        }
        return ImmutableSet.black(tree.left, tree.key, tree.right);
    }

    public boolean forEach(TObjectProcedure<T> procedure) {
        if (this.left.forEach(procedure) && procedure.execute(this.key)) {
            return this.right.forEach(procedure);
        }
        return false;
    }

    public ImmutableSet<T> addAll(Iterable<T> c) {
        ImmutableSet<Comparable> ret = this;
        for (Comparable t : c) {
            ret = ret.add(t);
        }
        return ret;
    }

    public ImmutableSet<T> addAll(ImmutableSet<T> c) {
        if (this == EMPTY) {
            return c;
        }
        if (c == EMPTY) {
            return this;
        }
        AddAll proc = new AddAll(this);
        c.forEach(proc);
        return proc.result;
    }

    void print(int indentation) {
        this.left.print(indentation + 1);
        int i = 0;
        while (i < indentation) {
            System.out.print("    ");
            ++i;
        }
        System.out.println(String.valueOf(this.key) + " " + (this.isBlack ? "BLACK" : "RED"));
        this.right.print(indentation + 1);
    }

    private int validateRec() {
        int rh;
        if (this == EMPTY) {
            return 1;
        }
        int lh = this.left.validateRec();
        if (lh != (rh = this.right.validateRec())) {
            System.out.println("Unbalanced!");
        }
        if (!this.isBlack) {
            if (!this.left.isBlack || !this.right.isBlack) {
                System.out.println("Red under red");
            }
            return lh;
        }
        return lh + 1;
    }

    public static <T extends Comparable<T>> ImmutableSet<T> empty() {
        return EMPTY;
    }

    public void validate() {
        this.validateRec();
        if (!this.isBlack) {
            System.out.println("Root is not black");
        }
    }

    public static void main(String[] args) {
        ImmutableSet<Integer> set = EMPTY;
        final HashSet<Integer> set2 = new HashSet<Integer>();
        Random random = new Random();
        int i = 0;
        while (i < 10000) {
            int r1 = random.nextInt(1000);
            int r2 = random.nextInt(1000);
            set = set.add(r1);
            set = set.remove(r2);
            set2.add(r1);
            set2.remove(r2);
            set.validate();
            for (Integer v : set2) {
                if (set.contains(v)) continue;
                System.out.println("set2 has more elements");
            }
            set.forEach(new TObjectProcedure<Integer>(){

                public boolean execute(Integer arg0) {
                    if (!set2.contains(arg0)) {
                        System.out.println("set has more elements");
                    }
                    return true;
                }
            });
            ++i;
        }
    }

    static class AddAll<T extends Comparable<T>>
    implements TObjectProcedure<T> {
        ImmutableSet<T> result;

        public AddAll(ImmutableSet<T> result) {
            this.result = result;
        }

        public boolean execute(T arg0) {
            this.result = this.result.add(arg0);
            return true;
        }
    }

    private static class EmptyImmutableSet<T extends Comparable<T>>
    extends ImmutableSet<T> {
        public EmptyImmutableSet() {
            this.isBlack = true;
        }

        @Override
        protected ImmutableSet<T> addRec(T obj) {
            return new ImmutableSet<T>(obj);
        }

        @Override
        protected ImmutableSet<T> removeRec(T obj) {
            return null;
        }

        @Override
        public boolean contains(T obj) {
            return false;
        }

        @Override
        public boolean forEach(TObjectProcedure<T> arg0) {
            return true;
        }

        @Override
        void print(int arg0) {
        }
    }
}

