/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures.hints;

import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.HintStack;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;

public class HintStackTest {
    public static final IHintContext.Key KEY = new IHintContext.KeyOf(Double.class);

    public static void main(String[] args) {
        HintStack stack = new HintStack();
        stack.addHintListener(new IHintListener(){

            @Override
            public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
                System.out.println("Hint changed: " + String.valueOf(key) + "=" + String.valueOf(newValue) + " (was " + String.valueOf(oldValue) + ")");
            }

            @Override
            public void hintRemoved(IHintObservable sender, IHintContext.Key key, Object oldValue) {
                System.out.println("Hint removed: " + String.valueOf(key) + " (was " + String.valueOf(oldValue) + ")");
            }
        });
        HintContext c1 = new HintContext();
        HintContext c2 = new HintContext();
        c1.setHint(KEY, 1.0);
        c2.setHint(KEY, 2.0);
        stack.addHintContext(c1, 0);
        stack.addHintContext(c2, 1);
        stack.removeHintContext(c1);
        stack.addHintContext(c1, 2);
        c2.setHint(KEY, 3.0);
        c1.setHint(KEY, 4.0);
        c1.removeHint(KEY);
    }
}

