/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.PriorityQueue;

public class TreeProblem {
    private static final Comparator<ProblemNode> COST_COMPARATOR = new Comparator<ProblemNode>(){

        @Override
        public int compare(ProblemNode o1, ProblemNode o2) {
            double c2;
            double c1 = o1.getCost();
            if (c1 < (c2 = o2.getCost())) {
                return -1;
            }
            if (c1 > c2) {
                return 1;
            }
            return 0;
        }
    };

    public static ProblemNode findSolution(ProblemNode root, int degree) {
        LinkedList<LinkedList<ProblemNode>> stack = new LinkedList<LinkedList<ProblemNode>>();
        LinkedList<ProblemNode> lst = new LinkedList<ProblemNode>();
        lst.add(root);
        stack.add(lst);
        while (!stack.isEmpty()) {
            lst = (LinkedList<ProblemNode>)stack.peekLast();
            ProblemNode b = (ProblemNode)lst.removeFirst();
            if (lst.isEmpty()) {
                stack.removeLast();
            }
            if (b.isComplete()) {
                return b;
            }
            lst = new LinkedList<ProblemNode>();
            b.branch(lst);
            if (lst.isEmpty()) continue;
            Collections.sort(lst, COST_COMPARATOR);
            stack.addLast(lst);
        }
        return null;
    }

    public static ProblemNode findOptimalSolution(ProblemNode root) {
        ArrayList<ProblemNode> lst = new ArrayList<ProblemNode>();
        PriorityQueue<ProblemNode> pq = new PriorityQueue<ProblemNode>(16, COST_COMPARATOR);
        pq.add(root);
        while (!pq.isEmpty()) {
            ProblemNode node = pq.poll();
            if (node.isComplete()) {
                return node;
            }
            lst.clear();
            node.branch(lst);
            pq.addAll(lst);
        }
        return null;
    }

    public static interface ProblemNode {
        public double getCost();

        public boolean isComplete();

        public void branch(Collection<ProblemNode> var1);
    }
}

