/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures;

import java.util.Objects;

public final class Pair2<T1, T2> {
    public final T1 first;
    public final T2 second;
    private final int hash;

    public static <T1, T2> Pair2<T1, T2> make(T1 t1, T2 t2) {
        return new Pair2<T1, T2>(t1, t2);
    }

    public Pair2(T1 first, T2 second) {
        this.first = first;
        this.second = second;
        this.hash = this.makeHash();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        Pair2 other = (Pair2)obj;
        if (!Objects.equals(other.first, this.first)) {
            return false;
        }
        return Objects.equals(other.second, this.second);
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return "<" + String.valueOf(this.first) + ", " + String.valueOf(this.second) + ">";
    }

    private int makeHash() {
        int result = 0;
        if (this.first != null) {
            result ^= this.first.hashCode();
        }
        if (this.second != null) {
            result ^= this.second.hashCode();
        }
        return result;
    }
}

