/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures;

public final class Pair<T1, T2>
implements Comparable<Pair<T1, T2>> {
    public final T1 first;
    public final T2 second;
    private final int hash;

    public static <T1, T2> Pair<T1, T2> make(T1 t1, T2 t2) {
        return new Pair<T1, T2>(t1, t2);
    }

    public Pair(T1 first, T2 second) {
        this.first = first;
        this.second = second;
        this.hash = this.makeHash();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        Pair other = (Pair)obj;
        if (!(other.first == this.first || other.first != null && other.first.equals(this.first))) {
            return false;
        }
        return other.second == this.second || other.second != null && other.second.equals(this.second);
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return "<" + String.valueOf(this.first) + ", " + String.valueOf(this.second) + ">";
    }

    private int makeHash() {
        return (this.first == null ? 0 : this.first.hashCode()) + (this.second == null ? 0 : this.second.hashCode()) * 31;
    }

    @Override
    public int compareTo(Pair<T1, T2> arg0) {
        if (this.first instanceof Comparable && this.second instanceof Comparable) {
            int c1 = ((Comparable)this.first).compareTo(arg0.first);
            if (c1 != 0) {
                return c1;
            }
            return ((Comparable)this.second).compareTo(arg0.second);
        }
        return this.hash - arg0.hash;
    }
}

