/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MultiDimensionArrayUtils {
    public static void printArrayDeep(Object v, PrintStream out) {
        ArrayIterator i = MultiDimensionArrayUtils.arrayIterator(v, MultiDimensionArrayUtils.getArrayLengths(v));
        while (i.hasNext()) {
            System.out.println(Arrays.toString(i.getIndices()) + " = " + String.valueOf(i.next()));
        }
    }

    public static int[] getArrayLengths(Object value) {
        int dim = MultiDimensionArrayUtils.getDimension(value.getClass());
        int[] result = new int[dim];
        if (dim == 0) {
            return result;
        }
        Object o = value;
        int i = 0;
        while (i < dim) {
            result[i] = Array.getLength(o);
            if (result[i] == 0) break;
            o = Array.get(o, 0);
            ++i;
        }
        return result;
    }

    public static int getDimension(Class<?> clazz) {
        String signature = clazz.getName();
        int dim = 0;
        while (dim < signature.length()) {
            if (signature.charAt(dim) != '[') break;
            ++dim;
        }
        return dim;
    }

    public static Object[] createMultiDimArray(Class<?> componentType, int[] dims) {
        return (Object[])Array.newInstance(componentType, dims);
    }

    public static int getLength(int[] dims) {
        int len = dims[0];
        int i = 1;
        while (i < dims.length) {
            len *= dims[i];
            ++i;
        }
        return len;
    }

    public static Class<?> getComponentType(Class<?> clazz) {
        Class<?> result = clazz;
        while (result.isArray()) {
            result = result.getComponentType();
        }
        return result;
    }

    public static Object demuxArray(Object src, int[] dims) {
        return MultiDimensionArrayUtils.demuxArray(src, dims, MultiDimensionArrayUtils.getComponentType(src.getClass()));
    }

    public static Object demuxArray(Object src, int[] dims, Class<?> componentType) {
        Object dst = Array.newInstance(componentType, dims);
        MultiDimensionArrayUtils._fillDemux(0, dims, src, 0, dst);
        return dst;
    }

    public static void demuxArray(Object src, int[] dims, Object dst) {
        if (Array.getLength(src) != MultiDimensionArrayUtils.getLength(dims)) {
            throw new IllegalArgumentException("The length of src does not match the length of dst");
        }
        MultiDimensionArrayUtils._fillDemux(0, dims, src, 0, dst);
    }

    private static int _fillDemux(int lvl, int[] dims, Object src, int srcIndex, Object dst) {
        if (lvl == dims.length - 1) {
            int len = dims[dims.length - 1];
            System.arraycopy(src, srcIndex, dst, 0, len);
            return srcIndex + len;
        }
        int i = 0;
        while (i < dims[lvl]) {
            srcIndex = MultiDimensionArrayUtils._fillDemux(lvl + 1, dims, src, srcIndex, Array.get(dst, i));
            ++i;
        }
        return srcIndex;
    }

    public static Object muxArray(Object src) {
        return MultiDimensionArrayUtils.muxArray(src, MultiDimensionArrayUtils.getArrayLengths(src), MultiDimensionArrayUtils.getComponentType(src.getClass()));
    }

    public static Object muxArray(Object src, int[] dims) {
        return MultiDimensionArrayUtils.muxArray(src, dims, MultiDimensionArrayUtils.getComponentType(src.getClass()));
    }

    public static Object muxArray(Object src, int[] dims, Class<?> componentType) {
        int len = MultiDimensionArrayUtils.getLength(dims);
        Object dst = Array.newInstance(componentType, len);
        MultiDimensionArrayUtils.muxArray(src, dims, dst);
        return dst;
    }

    public static void muxArray(Object src, int[] dims, Object dst) {
        int len = MultiDimensionArrayUtils.getLength(dims);
        if (Array.getLength(dst) != len) {
            throw new IllegalArgumentException("The length of src does not match the length of dst");
        }
        MultiDimensionArrayUtils._fillMux(0, dims, src, dst, 0);
    }

    private static int _fillMux(int lvl, int[] dims, Object src, Object dst, int dstIndex) {
        if (lvl == dims.length - 1) {
            int len = dims[lvl];
            System.arraycopy(src, 0, dst, dstIndex, len);
            return dstIndex + len;
        }
        int i = 0;
        while (i < dims[lvl]) {
            dstIndex += MultiDimensionArrayUtils._fillMux(lvl + 1, dims, Array.get(src, i), dst, dstIndex);
            ++i;
        }
        return 0;
    }

    public static <R> ArrayIterator<R> arrayIterator(Object array, int[] dimLens) {
        return new ArrayIterator(array, dimLens);
    }

    public static class ArrayIterator<T>
    implements Iterator<T> {
        Object v;
        int[] dims;
        int[] indices;
        Object[] arrays;
        int lastIndex;
        int len;
        boolean hasNext = true;

        ArrayIterator(Object array, int[] dimLens) {
            this.v = array;
            this.dims = dimLens;
            this.indices = new int[dimLens.length];
            this.arrays = new Object[dimLens.length];
            this.lastIndex = dimLens.length - 1;
            int cfr_ignored_0 = dimLens[0];
            int i = 0;
            while (i <= this.lastIndex) {
                if (dimLens[i] == 0) {
                    this.hasNext = false;
                }
                ++i;
            }
            i = 1;
            while (i <= this.lastIndex) {
                int cfr_ignored_1 = dimLens[i];
                ++i;
            }
            this.arrays[0] = (Object[])this.v;
            i = 1;
            while (i < dimLens.length) {
                this.arrays[i] = ((Object[])this.arrays[i - 1])[0];
                ++i;
            }
        }

        public int[] getIndices() {
            return this.indices;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        private void _next() {
            int index;
            block6: {
                int n;
                block5: {
                    index = this.lastIndex;
                    if (!true) break block5;
                    n = index;
                    if ((this.indices[n] = this.indices[n] + 1) < this.dims[index]) break block6;
                }
                do {
                    this.indices[index] = 0;
                    if (--index < 0) {
                        this.hasNext = false;
                        return;
                    }
                    this.arrays[index + 1] = ((Object[])this.arrays[index])[this.indices[index]];
                    n = index;
                } while ((this.indices[n] = this.indices[n] + 1) >= this.dims[index]);
            }
            if (index < this.lastIndex) {
                int i = index + 1;
                while (i <= this.lastIndex) {
                    this.arrays[i] = ((Object[])this.arrays[i - 1])[this.indices[i - 1]];
                    ++i;
                }
            }
        }

        @Override
        public T next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            Object result = Array.get(Array.get(this.arrays, this.lastIndex), this.indices[this.lastIndex]);
            this._next();
            return (T)result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove array element");
        }
    }
}

