/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.simantics.utils.datastructures.BijectionMap;

public class MappingWithContext<Context, Key> {
    Map<Context, BijectionMap<Key, Key>> maps = new HashMap<Context, BijectionMap<Key, Key>>();

    public synchronized void addMapping(Context context, Key leftKey, Key rightKey) {
        BijectionMap<Key, Key> map = this.getOrCreateMap(context);
        map.map(leftKey, rightKey);
    }

    public synchronized Key getAtMostOneMappingWithLeftKey(Context[] contexts, Key leftKey) throws IntersectingContextsException {
        Key result = null;
        Object resultContext = null;
        Context[] ContextArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            Key value;
            Context c = ContextArray[n2];
            BijectionMap<Key, Key> map = this.maps.get(c);
            if (map != null && (value = map.getRight(leftKey)) != null) {
                if (result != null) {
                    throw new IntersectingContextsException(resultContext, value, result);
                }
                result = value;
                resultContext = c;
            }
            ++n2;
        }
        return result;
    }

    public synchronized Key getAtMostOneMappingWithRightKey(Context[] contexts, Key rightKey) throws IntersectingContextsException {
        Key result = null;
        Object resultContext = null;
        Context[] ContextArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            Key value;
            Context c = ContextArray[n2];
            BijectionMap<Key, Key> map = this.maps.get(c);
            if (map != null && (value = map.getLeft(rightKey)) != null) {
                if (result != null) {
                    throw new IntersectingContextsException(resultContext, value, result);
                }
                result = value;
                resultContext = c;
            }
            ++n2;
        }
        return result;
    }

    public synchronized Set<Key> getMappingWithLeftKey(Context[] contexts, Key leftKey) throws IntersectingContextsException {
        HashSet<Key> result = new HashSet<Key>();
        Context[] ContextArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            Key value;
            Context c = ContextArray[n2];
            BijectionMap<Key, Key> map = this.maps.get(c);
            if (map != null && (value = map.getRight(leftKey)) != null) {
                result.add(value);
            }
            ++n2;
        }
        return result;
    }

    public synchronized Set<Key> getMappingWithRightKey(Context[] contexts, Key rightKey) throws IntersectingContextsException {
        HashSet<Key> result = new HashSet<Key>();
        Context[] ContextArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            Key value;
            Context c = ContextArray[n2];
            BijectionMap<Key, Key> map = this.maps.get(c);
            if (map != null && (value = map.getLeft(rightKey)) != null) {
                result.add(value);
            }
            ++n2;
        }
        return result;
    }

    private synchronized BijectionMap<Key, Key> getOrCreateMap(Context context) {
        BijectionMap<Object, Object> result = this.maps.get(context);
        if (result != null) {
            return result;
        }
        result = new BijectionMap();
        this.maps.put(context, result);
        return result;
    }

    public synchronized void addMapToContext(Context context, BijectionMap<Key, Key> map) {
        BijectionMap<Key, Key> m = this.getOrCreateMap(context);
        m.addAll(map);
    }

    public synchronized Set<Context> getContexts() {
        return Collections.unmodifiableSet(this.maps.keySet());
    }

    public synchronized Set<Key> getLeftKeys(Context context) {
        BijectionMap<Key, Key> map = this.maps.get(context);
        if (map == null) {
            return null;
        }
        return Collections.unmodifiableSet(map.getLeftSet());
    }

    public synchronized Set<Key> getRightKeys(Context context) {
        BijectionMap<Key, Key> map = this.maps.get(context);
        if (map == null) {
            return null;
        }
        return Collections.unmodifiableSet(map.getRightSet());
    }

    public synchronized Set<Key> getAllLeftKeys() {
        HashSet<Key> result = new HashSet<Key>();
        for (Context context : this.getContexts()) {
            result.addAll(this.getLeftKeys(context));
        }
        return result;
    }

    public synchronized Set<Key> getAllRightKeys() {
        HashSet<Key> result = new HashSet<Key>();
        for (Context context : this.getContexts()) {
            result.addAll(this.getRightKeys(context));
        }
        return result;
    }

    public String toString() {
        int count = 0;
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Map.Entry<Context, BijectionMap<Key, Key>> e : this.maps.entrySet()) {
            if (count++ > 0) {
                sb.append(", ");
            }
            sb.append(e.getKey() == null ? "null" : e.getKey().toString());
            sb.append("=");
            sb.append(e.getValue().toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public static class IntersectingContextsException
    extends Exception {
        private static final long serialVersionUID = 3411795376917295313L;

        public IntersectingContextsException(Object c, Object key1, Object key2) {
            super("The two keys " + String.valueOf(key1) + " and " + String.valueOf(key2) + " are intersecting in context " + String.valueOf(c));
        }
    }
}

