/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BijectionMap<L, R> {
    private final Map<L, R> tableLeft = new HashMap<L, R>();
    private final Map<R, L> tableRight = new HashMap<R, L>();
    private final Map<L, R> imTableLeft = Collections.unmodifiableMap(this.tableLeft);
    private final Map<R, L> imTableRight = Collections.unmodifiableMap(this.tableRight);
    private final Set<L> imLeftSet = Collections.unmodifiableSet(this.tableLeft.keySet());
    private final Set<R> imRightSet = Collections.unmodifiableSet(this.tableRight.keySet());

    public BijectionMap() {
    }

    public BijectionMap(BijectionMap<L, R> copyFrom) {
        this.tableLeft.putAll(copyFrom.tableLeft);
        this.tableRight.putAll(copyFrom.tableRight);
    }

    public void addAll(BijectionMap<L, R> map) {
        for (Map.Entry<L, R> e : map.getEntries()) {
            this.map(e.getKey(), e.getValue());
        }
    }

    public boolean retainAllLeft(Collection<L> values) {
        boolean result = false;
        ArrayList<L> remove = new ArrayList<L>(this.size());
        for (Object lValue : this.imLeftSet) {
            if (values.contains(lValue)) continue;
            remove.add(lValue);
            result = true;
        }
        if (!remove.isEmpty()) {
            for (Object lValue : remove) {
                this.removeWithLeft(lValue);
            }
        }
        return result;
    }

    public boolean retainAllRight(Collection<R> values) {
        boolean result = false;
        ArrayList<R> remove = new ArrayList<R>(this.size());
        for (Object rValue : this.imRightSet) {
            if (values.contains(rValue)) continue;
            remove.add(rValue);
            result = true;
        }
        if (!remove.isEmpty()) {
            for (Object rValue : remove) {
                this.removeWithRight(rValue);
            }
        }
        return result;
    }

    public Set<Map.Entry<L, R>> getEntries() {
        return this.tableLeft.entrySet();
    }

    public boolean containsLeft(L leftValue) {
        return this.tableLeft.containsKey(leftValue);
    }

    public boolean containsRight(R rightValue) {
        return this.tableRight.containsKey(rightValue);
    }

    public boolean contains(L leftValue, R rightValue) {
        if (leftValue == null || rightValue == null) {
            return false;
        }
        return rightValue.equals(this.tableLeft.get(leftValue));
    }

    public void map(L leftValue, R rightValue) {
        if (leftValue == null || rightValue == null) {
            throw new NullPointerException();
        }
        R oldRight = this.tableLeft.remove(leftValue);
        if (oldRight != null) {
            this.tableRight.remove(oldRight);
        } else {
            L oldLeft = this.tableRight.remove(rightValue);
            if (oldLeft != null) {
                this.tableLeft.remove(oldLeft);
            }
        }
        this.tableLeft.put(leftValue, rightValue);
        this.tableRight.put(rightValue, leftValue);
    }

    public boolean isEmpty() {
        return this.tableLeft.isEmpty();
    }

    public int size() {
        return this.tableLeft.size();
    }

    public L getLeft(R rightValue) {
        return this.tableRight.get(rightValue);
    }

    public R getRight(L leftValue) {
        return this.tableLeft.get(leftValue);
    }

    public R removeWithLeft(L leftValue) {
        R rightValue = this.tableLeft.remove(leftValue);
        if (rightValue != null) {
            this.tableRight.remove(rightValue);
        }
        return rightValue;
    }

    public L removeWithRight(R rightValue) {
        L leftValue = this.tableRight.remove(rightValue);
        if (leftValue != null) {
            this.tableLeft.remove(leftValue);
        }
        return leftValue;
    }

    public Set<L> getLeftSet() {
        return this.imLeftSet;
    }

    public Set<R> getRightSet() {
        return this.imRightSet;
    }

    public Map<L, R> getLeftToRightMap() {
        return this.imTableLeft;
    }

    public Map<R, L> getRightToLeftMap() {
        return this.imTableRight;
    }

    public void clear() {
        this.tableLeft.clear();
        this.tableRight.clear();
    }

    public String toString() {
        int count = 0;
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Map.Entry<L, R> e : this.tableLeft.entrySet()) {
            if (count++ > 0) {
                sb.append(", ");
            }
            sb.append(e.getKey().toString());
            sb.append("=");
            sb.append(e.getValue().toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public BijectionMap<L, R> clone() {
        return new BijectionMap<L, R>(this);
    }
}

