/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.datastructures.cache;

public class StaticProvider<V> implements IProvider<V> {

	private final V v;
	
	public static <V> IProvider<V> provide(V v)
	{
		return new StaticProvider<V>(v);
	}
	
	public StaticProvider(V v) {
		this.v = v;
	}

	@Override
	public V get() throws ProvisionException {
		return v;
	}
	
}
