/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.datastructures;

/**
 * @author Toni Kalajainen
 */
public class TypeCastException extends ClassCastException {

    private static final long serialVersionUID = 1L;
    private Class<?> unsupportedDataType;
    
    public TypeCastException(Class<?> unsupportedType) {
        super("TypeCast Exception, cannot read data type \""+unsupportedType.getName()+"\"");
        this.unsupportedDataType = unsupportedType;
    }
    
    public TypeCastException(Class<?> unsupportedType, Class<?> expectedType) {
        super("TypeCast Exception, cannot read data type \""+unsupportedType.getName()+"\", expected type was \""+expectedType.getName()+"\"");
        this.unsupportedDataType = unsupportedType;
    }
    
    public TypeCastException(String msg) {
        super(msg);
        this.unsupportedDataType = null;
    }
    
    public Class<?> getUnsupportedDataType() {
        return unsupportedDataType;
    }    

}
