/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 *
 * @author Toni Kalajainen
 */
package org.simantics.utils.datastructures;

import java.util.Objects;

import org.simantics.utils.datastructures.map.Tuple;

/**
 * A generic Pair (2-tuple) structure for containing two object instances of
 * chosen types.
 * 
 * Allows nulls
 * 
 * @param <T1> type of first element
 * @param <T2> type of second element
 * @deprecated Replaced with {@link Tuple}
 */
public final class Pair2<T1, T2> {
    public final T1 first;
    public final T2 second;
    private final int hash;

    public static <T1, T2> Pair2<T1, T2> make(T1 t1, T2 t2) {
        return new Pair2<T1, T2>(t1, t2);
    }

    public Pair2(T1 first, T2 second) {
        this.first = first;
        this.second = second;
        this.hash = makeHash();
    }
    
    @Override
    public boolean equals(Object obj) {
        if (obj == null)
            return false;
        if (!(obj.getClass().equals(this.getClass())))
            return false;
        Pair2<?, ?> other = (Pair2<?, ?>) obj;
        if (!Objects.equals(other.first, first))
            return false;
        if (!Objects.equals(other.second, second))
            return false;
        return true;
    }
    
    @Override
    public int hashCode() {
        return hash;
    }
    
    @Override
    public String toString() {
        return "<"+first+", "+second+">";
    }
    
    private int makeHash() {
    	int result = 0;
    	if (first!=null)
    		result ^= first.hashCode();
    	if (second!=null)
    		result ^= second.hashCode();
        return result;
    }
}
