/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.datastructures;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;


public class ImmutableSList<T> extends ImmutableCollection<T> {
	
	final public T                 head;
	final public ImmutableSList<T> tail; // null, if this is the last element
	
	public ImmutableSList(T head, ImmutableSList<T> tail) {
		this.head = head;
		this.tail = tail;
	}
	
	public ImmutableSList(T head) {
		this(head, null);
	}
	
	@Override
	public boolean contains(Object o) {
		ImmutableSList<T> cur = this;
		do {
			if(cur.head.equals(o))
				return true;
			cur = cur.tail;
		} while(cur != null);
		return false;	
	}
	@Override
	public boolean containsAll(Collection<?> c) {
		for(Object o : c)
			if(!contains(o))
				return false;
		return true;
	}
	@Override
	public boolean isEmpty() {
		return false;
	}
	
	static private class Iter<T> implements Iterator<T> {
		public ImmutableSList<T> cur;
		
		public Iter(ImmutableSList<T> cur) {
			this.cur = cur;
		}

		@Override
		public boolean hasNext() {
			return cur != null;
		}

		@Override
		public T next() {
			if(cur == null)
				throw new NoSuchElementException();
			T ret = cur.head;
			cur = cur.tail;
			return ret;
		}

		@Override
		public void remove() {
			throw new UnsupportedOperationException();
		}
		
	}
	
	@Override
	public Iterator<T> iterator() {
		return new Iter<T>(this);
	}
	@Override
	public int size() {
		ImmutableSList<T> cur = this;
		int count = 0;
		do {
			++count;
			cur = cur.tail;
		} while(cur != null);
		return count;	
	}
	
	

}
