/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.datastructures;

import java.util.Collection;
import java.util.Iterator;

public class CollectionAdapter<Domain, Range, C extends Collection<Domain>> 
implements Collection<Range> {

    protected Converter<Domain, Range> converter;
    protected C                        collection;  
      
    public CollectionAdapter(Converter<Domain, Range> converter, C collection) {
        this.converter = converter;
        this.collection = collection;
    }
    @Override
    public boolean add(Range e) {
        return collection.add(converter.convertFrom(e));
    }
    @SuppressWarnings("unchecked")
    @Override
    public boolean addAll(Collection<? extends Range> c) {
        return collection.addAll(new CollectionAdapter<Range, Domain, Collection<Range>>(inverseConverter(converter), (Collection<Range>)c));
    }
    @Override
    public void clear() {
        collection.clear();
    }
    @SuppressWarnings("unchecked")
    @Override
    public boolean contains(Object o) {
        return collection.contains(converter.convertFrom((Range)o));
    }
    @Override
    public boolean containsAll(Collection<?> c) {
        for(Object o : c)
            if(!contains(o))
                return false;
        return true;
    }
    @Override
    public boolean isEmpty() {
        return collection.isEmpty();
    }
    @Override
    public Iterator<Range> iterator() {
        return new IteratorAdapter<Domain, Range, Iterator<Domain>>(converter, collection.iterator());                
    }
    @SuppressWarnings("unchecked")
    @Override
    public boolean remove(Object o) {
        return collection.remove(converter.convertFrom((Range)o));
    }
    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removed = false;
        for(Object o : c)
            removed |= remove(o);
        return removed;
    }
    @SuppressWarnings("unchecked")
    @Override
    public boolean retainAll(Collection<?> c) {
        // FIXME
        return collection.retainAll(new CollectionAdapter<Range, Domain, Collection<Range>>(inverseConverter(converter), (Collection<Range>)c));
    }
    @Override
    public int size() {
        return collection.size();
    }
    @Override
    public Object[] toArray() {
        Object[] ret = new Object[collection.size()];
        int i=0;
        for(Domain d : collection)
            ret[i++] = converter.convertTo(d);
        return ret;
    }
    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }
    
    public static <D,R> Converter<R,D> inverseConverter(final Converter<D,R> converter) {
        return new Converter<R,D>() {

            @Override
            public R convertFrom(D rangeElement) {
                return converter.convertTo(rangeElement);
            }

            @Override
            public D convertTo(R domainElement) {
                return converter.convertFrom(domainElement);
            }
            
        };
    }
    
}
