/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 * 18.8.2006
 */
package org.simantics.utils.datastructures;

import java.util.Arrays;

/**
 * Deep comparable array object.
 * 
 * @author Toni Kalajainen
 */
public final class Array<T> {

    private final T[] array;
    private final int hashCode;    
    
    public Array(T[] array)
    {
        this.array = array.clone();
        this.hashCode = makeHashCode(this.array);
    }
    
    private static <T> int makeHashCode(T[] array) {
        int hash = 1;
        for (int i=0; i<array.length; i++)
        {
            if (array[i]==null) continue;
            hash = (31*hash) ^ array[i].hashCode();
        }
        return hash;
    }
    
    public T[] toArray()
    {
        return array.clone();
    }
    
    @Override
    public int hashCode() {
        return hashCode;
    }
    
    @Override
    public boolean equals(Object obj) {
        if (obj==this) return true;
        if (!obj.getClass().equals(getClass()))
            return false;
        return Arrays.equals(array, ((Array<?>)obj).array);
    }
    
    public int size() {
        return array.length;
    }
    
}
