/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.tester;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.Session;
import org.simantics.db.UndoContext;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.service.UndoRedoSupport;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.SWTUtils;

public class UndoPropertyTester
extends PropertyTester
implements UndoRedoSupport.ChangeListener {
    private static final String PROP_CAN_REDO = "canRedo";
    private static final String PROP_CAN_UNDO = "canUndo";
    private static final String SIMANTICS_UNDO_CONTEXT = "org.simantics.ui.undoContext";
    public static final boolean DEBUG = false;
    public static final String UNDO_ENABLED = "org.simantics.undo.enabled";
    UndoRedoSupport undoSupport = null;
    IContextActivation activation = null;
    private int oldUndo = 0;
    private int oldRedo = 0;

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        String undoEnabled = System.getProperty(UNDO_ENABLED);
        if (undoEnabled != null && "false".equals(undoEnabled)) {
            return false;
        }
        if (property.matches(PROP_CAN_UNDO)) {
            return this.canUndo();
        }
        if (property.matches(PROP_CAN_REDO)) {
            return this.canRedo();
        }
        return false;
    }

    private boolean canUndo() {
        UndoContext uc;
        block9: {
            Session s;
            block8: {
                block7: {
                    ISessionContext ctx = Simantics.getSessionContext();
                    if (ctx == null) {
                        return false;
                    }
                    try {
                        s = ctx.peekSession();
                        if (s != null) break block7;
                        return false;
                    }
                    catch (Exception e) {
                        ErrorLogger.getDefault().logError("Undo/Redo support failed.", (Throwable)e);
                        return false;
                    }
                }
                if (!DatabaseJob.inProgress()) break block8;
                return true;
            }
            if (this.undoSupport == null) {
                this.undoSupport = (UndoRedoSupport)s.getService(UndoRedoSupport.class);
                this.undoSupport.subscribe((UndoRedoSupport.ChangeListener)this);
            }
            if ((uc = this.undoSupport.getUndoContext(s)) != null) break block9;
            return false;
        }
        boolean ret = !uc.getAll().isEmpty();
        return ret;
    }

    private boolean canRedo() {
        UndoContext uc;
        block9: {
            Session s;
            block8: {
                block7: {
                    ISessionContext ctx = Simantics.getSessionContext();
                    if (ctx == null) {
                        return false;
                    }
                    try {
                        s = ctx.peekSession();
                        if (s != null) break block7;
                        return false;
                    }
                    catch (Exception e) {
                        ErrorLogger.getDefault().logError("Undo/Redo support failed.", (Throwable)e);
                        return false;
                    }
                }
                if (!DatabaseJob.inProgress()) break block8;
                return true;
            }
            if (this.undoSupport == null) {
                this.undoSupport = (UndoRedoSupport)s.getService(UndoRedoSupport.class);
                this.undoSupport.subscribe((UndoRedoSupport.ChangeListener)this);
            }
            if ((uc = this.undoSupport.getUndoContext(s)) != null) break block9;
            return false;
        }
        boolean ret = !uc.getRedoList().isEmpty();
        return ret;
    }

    public void onChanged() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        SWTUtils.asyncExec((Display)display, (Runnable)new Runnable(){

            @Override
            public void run() {
                UndoPropertyTester.this.handleChange();
            }
        });
    }

    private void handleChange() {
        int newUndo = this.oldUndo;
        int newRedo = this.oldRedo;
        try {
            boolean redoOff;
            ISessionContext ctx = Simantics.getSessionContext();
            if (ctx == null) {
                return;
            }
            Session session = ctx.peekSession();
            if (session == null) {
                return;
            }
            UndoContext uc = this.undoSupport.getUndoContext(session);
            if (uc == null) {
                return;
            }
            newUndo = uc.getAll().size();
            newRedo = uc.getRedoList().size();
            boolean undoOn = this.oldUndo == 0 && newUndo == 1;
            boolean undoOff = this.oldUndo > 0 && newUndo == 0;
            boolean redoOn = this.oldRedo == 0 && newRedo == 1;
            boolean bl = redoOff = this.oldRedo > 0 && newRedo == 0;
            if (undoOn || undoOff || redoOn || redoOff) {
                this.toggleContext();
            }
        }
        catch (DatabaseException e) {
            ErrorLogger.getDefault().logError("Undo/Redo support failed.", (Throwable)e);
        }
        this.oldUndo = newUndo;
        this.oldRedo = newRedo;
    }

    private void toggleContext() {
        IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
        if (this.activation != null) {
            try {
                contextService.deactivateContext(this.activation);
            }
            catch (Throwable t) {
                ErrorLogger.getDefault().logError("Undo/Redo support failed.", t);
            }
            this.activation = null;
        } else {
            try {
                this.activation = contextService.activateContext(SIMANTICS_UNDO_CONTEXT);
            }
            catch (Throwable t) {
                ErrorLogger.getDefault().logError("Undo/Redo support failed.", t);
                this.activation = null;
            }
        }
    }
}

