/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.selection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.IsInstanceOf;
import org.simantics.db.common.primitiverequest.Supertypes;
import org.simantics.db.common.primitiverequest.Types;
import org.simantics.db.common.uri.ResourceToPossibleURI;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleGUID;
import org.simantics.db.layer0.request.PossibleVariableGUID;
import org.simantics.db.layer0.request.PossibleVariableRepresents;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.request.VariableURI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.ui.selection.AnyResource;
import org.simantics.ui.selection.AnyVariable;
import org.simantics.ui.selection.WorkbenchSelectionContentType;
import org.simantics.ui.selection.WorkbenchSelectionElement;
import org.simantics.utils.ui.ISelectionUtils;

public class WorkbenchSelectionUtils {
    public static Resource getPossibleResource(ExecutionEvent event) throws DatabaseException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        return WorkbenchSelectionUtils.getPossibleResource(selection);
    }

    public static Variable getPossibleVariable(ExecutionEvent event) throws DatabaseException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        return WorkbenchSelectionUtils.getPossibleVariable(selection);
    }

    public static List<WorkbenchSelectionElement> getWorkbenchSelectionElements(ISelection selection) {
        return ISelectionUtils.filterSelection((ISelection)selection, WorkbenchSelectionElement.class);
    }

    public static List<String> getPossibleJSONs(Object selections) throws DatabaseException {
        List<WorkbenchSelectionElement> elements = WorkbenchSelectionUtils.getPossibleObjects(selections, WorkbenchSelectionElement.class);
        if (elements != null && !elements.isEmpty()) {
            ArrayList<String> result = new ArrayList<String>();
            for (WorkbenchSelectionElement wse : elements) {
                String json = WorkbenchSelectionUtils.getPossibleJSON(wse);
                if (json == null) continue;
                result.add(json);
            }
            return result;
        }
        return null;
    }

    public static String getPossibleJSON(Object selection) throws DatabaseException {
        WorkbenchSelectionElement element = WorkbenchSelectionUtils.getPossibleWorkbenchSelectionElement(selection);
        return element != null ? WorkbenchSelectionUtils.getPossibleJSON(element) : null;
    }

    public static Resource getPossibleResource(Object selection) throws DatabaseException {
        WorkbenchSelectionElement element = WorkbenchSelectionUtils.getPossibleWorkbenchSelectionElement(selection);
        return element != null ? WorkbenchSelectionUtils.getPossibleResource(element) : null;
    }

    public static Variable getPossibleVariable(Object selection) throws DatabaseException {
        WorkbenchSelectionElement element = WorkbenchSelectionUtils.getPossibleWorkbenchSelectionElement(selection);
        return element != null ? WorkbenchSelectionUtils.getPossibleVariable(element) : null;
    }

    public static Resource getPossibleResourceFromSelection(RequestProcessor processor, Object selection) throws DatabaseException {
        WorkbenchSelectionElement element = WorkbenchSelectionUtils.getPossibleWorkbenchSelectionElement(selection);
        return element != null ? WorkbenchSelectionUtils.getPossibleResource(processor, element) : null;
    }

    public static Variable getPossibleVariableFromSelection(RequestProcessor processor, Object selection) throws DatabaseException {
        WorkbenchSelectionElement element = WorkbenchSelectionUtils.getPossibleWorkbenchSelectionElement(selection);
        return element != null ? WorkbenchSelectionUtils.getPossibleVariable(processor, element) : null;
    }

    public static Variable getPossibleVariable(Object[] selection) throws DatabaseException {
        if (selection.length != 1) {
            return null;
        }
        if (!(selection[0] instanceof WorkbenchSelectionElement)) {
            return null;
        }
        return WorkbenchSelectionUtils.getPossibleVariable((WorkbenchSelectionElement)selection[0]);
    }

    public static <T> T getPossibleElement(Object[] selection, WorkbenchSelectionContentType<T> contentType) throws DatabaseException {
        if (selection.length != 1) {
            return null;
        }
        if (!(selection[0] instanceof WorkbenchSelectionElement)) {
            return null;
        }
        WorkbenchSelectionElement wse = (WorkbenchSelectionElement)selection[0];
        return wse.getContent(contentType);
    }

    public static String getPossibleJSON(WorkbenchSelectionElement wse) throws DatabaseException {
        return WorkbenchSelectionUtils.getPossibleJSON((RequestProcessor)Simantics.getSession(), wse);
    }

    public static Resource getPossibleResource(WorkbenchSelectionElement wse) throws DatabaseException {
        return WorkbenchSelectionUtils.getPossibleResource((RequestProcessor)Simantics.getSession(), wse);
    }

    public static Variable getPossibleVariable(WorkbenchSelectionElement wse) throws DatabaseException {
        return WorkbenchSelectionUtils.getPossibleVariable((RequestProcessor)Simantics.getSession(), wse);
    }

    public static Variable getPossibleVariableSCL(ReadGraph graph, WorkbenchSelectionElement wse) throws DatabaseException {
        return WorkbenchSelectionUtils.getPossibleVariable((RequestProcessor)graph, wse);
    }

    public static Resource getPossibleResourceSCL(ReadGraph graph, WorkbenchSelectionElement wse) throws DatabaseException {
        return WorkbenchSelectionUtils.getPossibleResource((RequestProcessor)graph, wse);
    }

    public static String getPossibleJSON(RequestProcessor processor, Object input) throws DatabaseException {
        final Variable var = WorkbenchSelectionUtils.getPossibleVariable(processor, input);
        Resource res = WorkbenchSelectionUtils.getPossibleResource(processor, input);
        String typesStr = WorkbenchSelectionUtils.getTypeResourceString(processor, res, var);
        if (var != null) {
            String uri = (String)processor.syncRequest((Read)new VariableURI(var));
            String guid = (String)processor.syncRequest((Read)new PossibleVariableGUID(var));
            Set classifications = (Set)processor.syncRequest((Read)new VariableRead<Set<String>>(var){

                public Set<String> perform(ReadGraph graph) throws DatabaseException {
                    return var.getClassifications(graph);
                }
            });
            String classificationsStr = WorkbenchSelectionUtils.toJSONStringArray(new ArrayList<String>(classifications));
            Datatype datatype = (Datatype)processor.syncRequest((Read)new VariableRead<Datatype>(var){

                public Datatype perform(ReadGraph graph) throws DatabaseException {
                    return var.getPossibleDatatype(graph);
                }
            });
            return WorkbenchSelectionUtils.toJSONObjectString("type", "\"Variable\"", "uri", WorkbenchSelectionUtils.safeQuotedString(uri), "guid", WorkbenchSelectionUtils.safeQuotedString(guid), "resourceId", res == null ? "" : Long.toString(res.getResourceId()), "typeResources", typesStr, "classifications", classificationsStr, "datatype", WorkbenchSelectionUtils.safeQuotedString(datatype != null ? datatype.getClass().getName() : null));
        }
        if (res != null) {
            String uri = (String)processor.syncRequest((Read)new ResourceToPossibleURI(res));
            String guid = (String)processor.syncRequest((Read)new PossibleGUID(res));
            return WorkbenchSelectionUtils.toJSONObjectString("type", "\"Resource\"", "uri", WorkbenchSelectionUtils.safeQuotedString(uri), "guid", WorkbenchSelectionUtils.safeQuotedString(guid), "resourceId", Long.toString(res.getResourceId()), "typeResources", typesStr);
        }
        return "{ \"type\": \"Unknown\" }";
    }

    public static Resource getPossibleResource(RequestProcessor processor, Object input) throws DatabaseException {
        return WorkbenchSelectionUtils.getPossibleResource(processor, input, null);
    }

    public static Resource getPossibleResource(RequestProcessor processor, Object input, Resource type) throws DatabaseException {
        Object element;
        if (input instanceof Collection && !((Collection)input).isEmpty() && (element = ((Collection)input).iterator().next()) instanceof Resource) {
            return (Resource)element;
        }
        Resource resource = WorkbenchSelectionUtils.getPossibleElement(input, new AnyResource(processor));
        if (resource == null) {
            return resource;
        }
        if (type != null) {
            if (((Boolean)processor.sync((ReadInterface)new IsInstanceOf(resource, type))).booleanValue()) {
                return resource;
            }
            return null;
        }
        return resource;
    }

    public static Variable getPossibleVariable(RequestProcessor processor, Object input) throws DatabaseException {
        return WorkbenchSelectionUtils.getPossibleElement(input, new AnyVariable(processor));
    }

    public static <T> T getPossibleElement(Object input, WorkbenchSelectionContentType<T> contentType) {
        Object single = WorkbenchSelectionUtils.getPossibleSingleElement(input);
        if (single == null) {
            return null;
        }
        if (single instanceof WorkbenchSelectionElement) {
            WorkbenchSelectionElement element = (WorkbenchSelectionElement)single;
            return element.getContent(contentType);
        }
        return null;
    }

    public static WorkbenchSelectionElement getPossibleSelectionElement(Object input) {
        Object o;
        Collection c;
        if (input instanceof WorkbenchSelectionElement) {
            return (WorkbenchSelectionElement)input;
        }
        if (input instanceof Collection && (c = (Collection)input).size() == 1 && (o = c.iterator().next()) instanceof WorkbenchSelectionElement) {
            return (WorkbenchSelectionElement)o;
        }
        return null;
    }

    private static Object getPossibleSingleElement(Object input) {
        Collection c;
        if (input instanceof WorkbenchSelectionElement) {
            return input;
        }
        if (input instanceof Collection && (c = (Collection)input).size() == 1) {
            return c.iterator().next();
        }
        return null;
    }

    private static WorkbenchSelectionElement getPossibleWorkbenchSelectionElement(Object selection) {
        return WorkbenchSelectionUtils.getPossibleObject(selection, WorkbenchSelectionElement.class);
    }

    private static <T> T getPossibleObject(Object selection, Class<T> clazz) {
        return (T)(clazz.isInstance(selection) ? selection : ISelectionUtils.filterSingleSelection((Object)selection, clazz));
    }

    private static <T> List<T> getPossibleObjects(Object selection, Class<T> clazz) {
        T r = WorkbenchSelectionUtils.getPossibleObject(selection, clazz);
        if (r != null) {
            ArrayList<T> result = new ArrayList<T>();
            result.add(r);
            return result;
        }
        return ISelectionUtils.filterMultipleSelection((Object)selection, clazz);
    }

    private static String toJSONObjectString(String ... keyValuePairs) {
        int len = keyValuePairs.length;
        assert ((len & 1) == 0);
        StringBuilder sb = new StringBuilder(128);
        sb.append("{ ");
        int entryCount = 0;
        int i = 0;
        while (i < len) {
            String value = keyValuePairs[i + 1];
            if (value != null && !value.isEmpty()) {
                if (entryCount > 0) {
                    sb.append(", ");
                }
                sb.append("\"").append(keyValuePairs[i]).append("\": ").append(value);
                ++entryCount;
            }
            i += 2;
        }
        sb.append(" }");
        return sb.toString();
    }

    private static String escapeQuotes(String s) {
        return s.indexOf(34) >= 0 ? s.replaceAll("\"", "\\\\\"") : s;
    }

    private static String safeQuotedString(String s) {
        return s != null && !s.isEmpty() ? "\"" + WorkbenchSelectionUtils.escapeQuotes(s) + "\"" : "";
    }

    private static String toJSONStringArray(List<String> strings) throws DatabaseException {
        if (strings.isEmpty()) {
            return "";
        }
        return strings.stream().map(WorkbenchSelectionUtils::escapeQuotes).sorted().collect(Collectors.joining("\", \"", "[\"", "\"]"));
    }

    private static String getTypeResourceString(RequestProcessor processor, Resource r, Variable v) throws DatabaseException {
        return WorkbenchSelectionUtils.toJSONStringArray(WorkbenchSelectionUtils.toPossibleURIs(processor, WorkbenchSelectionUtils.getTypes(processor, r, v)));
    }

    private static Set<Resource> getTypes(RequestProcessor processor, Resource r, Variable v) throws DatabaseException {
        if (r == null && v != null) {
            r = (Resource)processor.syncRequest((Read)new PossibleVariableRepresents(v));
        }
        if (r != null) {
            return (Set)processor.syncRequest((AsyncRead)new Types(r));
        }
        r = v != null ? (Resource)processor.syncRequest((Read)new PossibleVariableType(v)) : null;
        return r != null ? (Set)processor.syncRequest((AsyncRead)new Supertypes(r)) : Collections.emptySet();
    }

    private static List<String> toPossibleURIs(RequestProcessor processor, Collection<Resource> resources) throws DatabaseException {
        if (resources.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(resources.size());
        for (Resource r : resources) {
            String uri = (String)processor.syncRequest((Read)new ResourceToPossibleURI(r));
            if (uri == null) continue;
            result.add(uri);
        }
        return result;
    }

    private static class PossibleVariableType
    extends VariableRead<Resource> {
        public PossibleVariableType(Variable var) {
            super(var);
        }

        public Resource perform(ReadGraph graph) throws DatabaseException {
            return this.variable.getPossibleType(graph);
        }
    }
}

