/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.contribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.contribution.DynamicMenuContribution;
import org.simantics.ui.contribution.IDynamicMenuContribution2;
import org.simantics.ui.selection.WorkbenchSelectionUtils;
import org.simantics.ui.workbench.action.ResourceEditorAdapterAction;
import org.simantics.ui.workbench.editor.EditorAdapter;
import org.simantics.ui.workbench.editor.EditorRegistry;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class OpenWithMenuContribution
extends DynamicMenuContribution
implements IExecutableExtension,
IDynamicMenuContribution2 {
    private static final boolean DEBUG_ADAPTERS = false;
    protected ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private String editorId = null;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if ("class".equals(propertyName)) {
            if (data instanceof String) {
                this.setEditorId((String)data);
            } else if (data instanceof Hashtable) {
                Hashtable params = (Hashtable)data;
                this.setEditorId((String)params.get("editorId"));
            }
            if ("activeEditorId".equals(this.editorId)) {
                this.setEditorId(WorkbenchUtils.getActiveWorkbenchPart().getSite().getId());
            }
        }
    }

    public String getEditorId() {
        return this.editorId;
    }

    public void setEditorId(String editorId) {
        this.editorId = editorId;
    }

    public void dispose() {
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
            this.resourceManager = null;
        }
        super.dispose();
    }

    protected Object extractResource(ReadGraph graph, Object object) throws DatabaseException {
        Resource resource = WorkbenchSelectionUtils.getPossibleResourceFromSelection((RequestProcessor)graph, object);
        return resource != null ? resource : object;
    }

    @Override
    protected boolean preAcceptSelection(Object[] selection) {
        return selection.length == 1;
    }

    protected String getText() {
        return "Open With";
    }

    @Override
    public boolean preAcceptSelection2(ISelection selection) {
        return selection instanceof IStructuredSelection ? !((IStructuredSelection)selection).isEmpty() : false;
    }

    @Override
    public IContributionItem[] getContributionItems2(ReadGraph graph, ISelection selection) throws DatabaseException {
        IStructuredSelection ss = (IStructuredSelection)selection;
        Object input = selection;
        if (ss.size() == 1 && (input = this.extractResource(graph, ss.getFirstElement())) == null) {
            return NONE;
        }
        EditorAdapter[] editorAdapters = this.resolveEditorAdapters(graph, input);
        if (editorAdapters.length == 0) {
            return NONE;
        }
        return new IContributionItem[]{this.openWithItem(editorAdapters, input)};
    }

    @Override
    protected IContributionItem[] getContributionItems(ReadGraph graph, Object[] selection) throws DatabaseException {
        Object input = this.extractResource(graph, selection[0]);
        if (input == null) {
            return NONE;
        }
        EditorAdapter[] editorAdapters = this.resolveEditorAdapters(graph, input);
        if (editorAdapters.length == 0) {
            return NONE;
        }
        return new IContributionItem[]{this.openWithItem(editorAdapters, input)};
    }

    protected ContributionItem openWithItem(final EditorAdapter[] editorAdapters, final Object input) {
        return new ContributionItem(){

            public void fill(Menu menu, int index) {
                MenuItem openWith = new MenuItem(menu, 64, index);
                openWith.setText(OpenWithMenuContribution.this.getText());
                openWith.setEnabled(editorAdapters.length > 0);
                Menu subMenu = new Menu(menu);
                openWith.setMenu(subMenu);
                if (editorAdapters.length > 0) {
                    Adapter[] adapters;
                    Adapter[] adapterArray = adapters = OpenWithMenuContribution.this.toAdapters(editorAdapters, input);
                    int n = adapters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Adapter a = adapterArray[n2];
                        OpenWithMenuContribution.this.addMenuItem(subMenu, a, input);
                        ++n2;
                    }
                }
            }
        };
    }

    protected Adapter[] toAdapters(EditorAdapter[] editorAdapters, Object r) {
        Adapter[] adapters = new Adapter[editorAdapters.length];
        int i = 0;
        while (i < editorAdapters.length) {
            adapters[i] = new Adapter(editorAdapters[i], r, true);
            ++i;
        }
        Arrays.sort(adapters, (o1, o2) -> {
            int delta = o2.getPriority() - o1.getPriority();
            if (delta != 0) {
                return delta;
            }
            return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)o1.getText(), (Object)o2.getText());
        });
        return adapters;
    }

    private EditorAdapter[] resolveEditorAdapters(ReadGraph graph, Object input) throws DatabaseException {
        return this.filter(EditorRegistry.getInstance().getAdaptersFor(graph, input), this.editorId);
    }

    protected EditorAdapter[] filter(EditorAdapter[] adapters, String id) {
        if (id == null) {
            return adapters;
        }
        ArrayList<EditorAdapter> editorAdapters = new ArrayList<EditorAdapter>(adapters.length);
        EditorAdapter[] editorAdapterArray = adapters;
        int n = adapters.length;
        int n2 = 0;
        while (n2 < n) {
            EditorAdapter a = editorAdapterArray[n2];
            if (!id.equals(a.getEditorId())) {
                editorAdapters.add(a);
            }
            ++n2;
        }
        return editorAdapters.toArray(new EditorAdapter[editorAdapters.size()]);
    }

    private void addMenuItem(Menu subMenu, Adapter adapter, Object r) {
        MenuItem item = new MenuItem(subMenu, 8);
        String text = adapter.getText();
        item.setText(text);
        ImageDescriptor descriptor = adapter.getImageDescriptor();
        if (descriptor != null) {
            item.setImage(this.resourceManager.createImage(descriptor));
        }
        item.addSelectionListener((SelectionListener)adapter);
    }

    protected static class Adapter
    extends ResourceEditorAdapterAction
    implements SelectionListener {
        boolean remember;

        public Adapter(EditorAdapter adapter, Object r, boolean remember) {
            super(adapter, r);
            this.remember = remember;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            this.run();
        }

        @Override
        protected void safeRun() throws Exception {
            super.safeRun();
            if (this.remember) {
                EditorRegistry.getInstance().getMappings().put(this.getResource(), this.getAdapter());
            }
        }
    }
}

