/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.icons;

import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.utils.datastructures.cache.ProvisionException;
import org.simantics.utils.ui.BundleUtils;

/**
 * FIXME: http://www.simantics.org/Layer0-1.0/HasModelledIcon no longer exists!
 */
public class GraphOrBundleImageDescriptorProvider implements ImageDescriptorProvider {

    private final Bundle    bundle;
    private final String    path;
    private ImageDescriptor desc;

    public GraphOrBundleImageDescriptorProvider(ReadGraph graph, final Resource resource, Bundle bundle, String path) {
        assert bundle != null;
        assert path != null;
        this.bundle = bundle;
        this.path = path;
        //System.out.println("new bundle image descriptor: " + bundle + ", " + path);
    }

    @Override
    public ImageDescriptor get() throws ProvisionException {
        if (desc == null) {
            desc = BundleUtils.getImageDescriptorFromBundle(bundle, path);
            if (desc == null)
                throw new ProvisionException("Could not find image in bundle '" + bundle + "' at path + '" + path + "'");
            // desc = ImageDescriptor.getMissingImageDescriptor();
        }
        return desc;
    }

}
