/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.auth;

import java.io.IOException;

import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Shell;
import org.simantics.db.management.discovery.ServerInfo;
import org.simantics.db.service.ServerInformation;
import org.simantics.ui.auth.model.LoginModel;
import org.simantics.ui.internal.Activator;
import org.simantics.utils.ui.ExceptionUtils;

/**
 * @author Tuukka Lehtonen
 */
public class AuthenticationUtils {

    /**
     * @param forServer
     * @param forceQuery always present query dialog regardless of the remember
     *        setting attribute
     * @return
     */
    public static LoginModel queryAuthenticationInfo(Shell parentShell, ServerInfo forServer, boolean forceQuery) {
        LoginModel model = loadAuthenticationInfo(forServer);
        if (model == null)
            model = new LoginModel(forServer);

        boolean remember = model.isRemember();
        if (remember) {
            // Verify that the model data contains at least something before
            // skipping the interactive query.
            if (model.getName().trim().isEmpty())
                remember = false;
        }
        if (!remember || forceQuery) {
            LoginDialog dialog = new LoginDialog(parentShell, Activator.getDefault().getDialogSettings(), model);
            if (dialog.open() != Dialog.OK)
                return null;
        }

        return model;
    }

    private static LoginModel loadAuthenticationInfo(ServerInfo forServer) {
        // Cannot store any info if the server cannot be identified uniquely.
        ServerInformation info = forServer.getInfo();
        if (info == null)
            return null;
        String id = formId(info);

//        try {
//            Preferences preferences = new InstanceScope().getNode(Activator.PLUGIN_ID);
//            if (!preferences.nodeExists(id))
//                return null;
//            Preferences server = preferences.node(id);
//            
//            String name = server.get("name", "");
//            String pass = server.get("pass", "");
//
//            return new LoginModel(forServer, name, pass, true, true);
//        } catch (BackingStoreException e) {
//            // Don't pass this forward, just log it.
//            ExceptionUtils.logAndShowError(e);
//            return null;
//        }

        try {
            ISecurePreferences preferences = SecurePreferencesFactory.getDefault().node("procore");
            if (!preferences.nodeExists(id))
                return null;
            ISecurePreferences server = preferences.node(id);
            
            String name = server.get("name", "");
            String pass = server.get("pass", "");

            return new LoginModel(forServer, name, pass, true, true);
        } catch (StorageException e) {
            // Don't pass this forward, just log it.
            ExceptionUtils.logAndShowError(e);
            return null;
        }
    }
    
    public static void storeAuthenticationInfo(ServerInfo forServer, LoginModel model) throws IOException {
        ServerInformation info = forServer.getInfo();
        if (info == null)
            throw new IllegalArgumentException("server information not available for uniquely identifying the server");
        String id = formId(info);

//        Preferences preferences = new InstanceScope().getNode(Activator.PLUGIN_ID);
//        Preferences server = preferences.node(id);
//        server.put("name", model.getName());
//        server.put("hash", hashData);
//        try {
//            server.flush();
//        } catch (BackingStoreException e) {
//            throw new IOException(e);
//        }

        ISecurePreferences preferences = SecurePreferencesFactory.getDefault().node("procore");
        ISecurePreferences server = preferences.node(id);
        try {
            server.put("name", model.getName(), false);
            server.put("pass", model.getPassword(), true);
            server.flush();
        } catch (StorageException e) {
            throw new IOException(e);
        }
    }

    private static String formId(ServerInformation info) {
        return info.getDatabaseId();
    }
    
}
