/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.trend.impl;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.g2d.utils.GridSpacing;
import org.simantics.g2d.utils.GridUtil;
import org.simantics.history.HistoryException;
import org.simantics.history.util.Stream;
import org.simantics.history.util.ValueBand;
import org.simantics.scenegraph.utils.ColorUtil;
import org.simantics.trend.configuration.TimeFormat;
import org.simantics.trend.configuration.TrendItem;
import org.simantics.trend.configuration.TrendSpec;
import org.simantics.trend.impl.ItemNode;
import org.simantics.trend.impl.Milestone;
import org.simantics.trend.impl.MilestoneSpec;
import org.simantics.trend.impl.TrendGraphicalNode;
import org.simantics.trend.impl.TrendNode;
import org.simantics.trend.impl.VertRuler;
import org.simantics.trend.impl.ViewRenderingProfile;

public class Plot
extends TrendGraphicalNode {
    public static final double VALUE_TIP_BOX_PLOT_MARGIN = 7.0;
    private static final double VALUE_TIP_BOX_FILM_MARGIN = 5.0;
    private static final long serialVersionUID = 6335497685577733932L;
    public static final BasicStroke BORDER_LINE_STROKE = new BasicStroke(1.0f, 2, 0, 10.0f, null, 0.0f);
    public static final BasicStroke MILESTONE_LINE_STROKE = new BasicStroke(1.0f, 2, 0, 10.0f, null, 0.0f);
    public static final BasicStroke TREND_LINE_STROKE = new BasicStroke(1.0f, 0, 0, 10.0f, null, 0.0f);
    public static final BasicStroke DASHED_LINE_STROKE = new BasicStroke(2.0f, 0, 0, 5.0f, new float[]{5.0f, 5.0f}, 0.0f);
    public static final BasicStroke DASHED_LINE_STROKE_2 = new BasicStroke(2.0f, 0, 0, 5.0f, new float[]{5.0f, 5.0f}, 5.0f);
    public static final BasicStroke DASHED_LINE_STROKE_INVERSE = new BasicStroke(1.0f, 0, 0, 5.0f, new float[]{3.0f, 8.0f}, 0.0f);
    public static final Color PLOT_AREA_BG_GRADIENT_COLOR_TOP = new Color(228, 228, 248);
    public static final Color PLOT_AREA_BG_GRADIENT_COLOR_BOTTOM = new Color(250, 250, 250);
    static final Font MILESTONE_FONT;
    static final Font BASELINE_FONT;
    static final Font TOOLTIP_FONT;
    static final GridSpacing SOME_SPACING;
    public static final Color GRID_LINE_COLOR;
    static final double DIAMOND_SIZE = 7.0;
    static final Path2D DIAMOND;
    double analogAreaHeight;
    double binaryAreaHeight;
    Rectangle2D valueTipBoxBounds = new Rectangle2D.Double();
    public static final AlphaComposite composite66;

    static {
        SOME_SPACING = GridSpacing.makeGridSpacing((double)100.0, (double)100.0, (double)15.0);
        GRID_LINE_COLOR = new Color(190, 190, 220);
        DIAMOND = new Path2D.Double();
        DIAMOND.moveTo(0.0, -14.0);
        DIAMOND.lineTo(7.0, -7.0);
        DIAMOND.lineTo(0.0, 0.0);
        DIAMOND.lineTo(-7.0, -7.0);
        DIAMOND.lineTo(0.0, -14.0);
        MILESTONE_FONT = new Font("Tahoma", 0, 8);
        BASELINE_FONT = new Font("Tahoma", 1, 8);
        TOOLTIP_FONT = new Font("Tahoma", 0, 13);
        composite66 = AlphaComposite.getInstance(3, 0.8f);
    }

    @Override
    protected void doRender(Graphics2D g2d) {
        Double time;
        ItemNode data;
        int i;
        int phase;
        GridSpacing yGrid;
        TrendNode trend = (TrendNode)this.getParent();
        TrendSpec ts = trend.spec;
        ViewRenderingProfile rprof = trend.renderingProfile;
        double w = this.bounds.getWidth();
        double h = this.bounds.getHeight();
        double from = trend.horizRuler.from;
        double end = trend.horizRuler.end;
        GridSpacing xGrid = trend.horizRuler.spacing;
        GridSpacing gridSpacing = yGrid = trend.vertRuler != null ? trend.vertRuler.spacing : SOME_SPACING;
        if (w < 1.0 || h < 1.0) {
            return;
        }
        if (trend.shapedirty) {
            trend.shapedirty = false;
            for (ItemNode node : trend.analogItems) {
                this.prepareItem(node, 0.0, this.analogAreaHeight);
            }
            for (ItemNode node : trend.binaryItems) {
                this.prepareItem(node, 0.0, this.analogAreaHeight);
            }
        }
        Paint bgp = rprof.backgroundColor2 == null ? rprof.backgroundColor1 : new GradientPaint(0.0f, (float)h, rprof.backgroundColor1, 0.0f, 0.0f, rprof.backgroundColor2, false);
        g2d.setPaint(bgp);
        g2d.fill(this.bounds);
        if (ts.viewProfile.showGrid) {
            g2d.setPaint(rprof.gridColor);
            g2d.setStroke(GridUtil.GRID_LINE_STROKE);
            GridUtil.paintGridLines((GridSpacing)xGrid, (GridSpacing)yGrid, (Graphics2D)g2d, (double)(from - trend.horizRuler.basetime), (double)(trend.vertRuler != null ? trend.vertRuler.min : 0.0), (double)w, (double)h, (double)this.analogAreaHeight);
        }
        Rectangle oldClip = g2d.getClipBounds();
        if (!trend.analogItems.isEmpty()) {
            Rectangle2D.Double analogAreaClip = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.analogAreaHeight);
            g2d.setClip(analogAreaClip);
            phase = 0;
            while (phase < 4) {
                i = 0;
                while (i < trend.analogItems.size()) {
                    data = trend.analogItems.get(i);
                    this.drawItem(g2d, data, 0.0, this.analogAreaHeight, phase);
                    ++i;
                }
                ++phase;
            }
            g2d.setClip(oldClip);
        }
        if (!trend.analogItems.isEmpty() && !trend.binaryItems.isEmpty()) {
            g2d.setColor(Color.BLACK);
            g2d.setStroke(GridUtil.GRID_LINE_STROKE);
            g2d.drawLine(0, (int)this.analogAreaHeight, (int)this.getWidth(), (int)this.analogAreaHeight);
        }
        if (!trend.binaryItems.isEmpty()) {
            Rectangle2D.Double binaryAreaClip = new Rectangle2D.Double(0.0, this.analogAreaHeight, this.getWidth(), this.binaryAreaHeight);
            g2d.setClip(binaryAreaClip);
            phase = 0;
            while (phase < 4) {
                i = 0;
                while (i < trend.binaryItems.size()) {
                    data = trend.binaryItems.get(i);
                    double y = this.analogAreaHeight + (double)i * BINARY[3];
                    this.drawItem(g2d, data, y, BINARY[2], phase);
                    ++i;
                }
                ++phase;
            }
            g2d.setClip(oldClip);
            g2d.setFont(RULER_FONT);
            int i2 = 0;
            while (i2 < trend.binaryItems.size()) {
                ItemNode data2 = trend.binaryItems.get(i2);
                g2d.setColor(data2.color);
                double fh = 9.0;
                double y = this.analogAreaHeight + (double)i2 * BINARY[3] + 1.0;
                double fy = y + (BINARY[3] - fh) / 2.0 + fh;
                g2d.drawString(data2.item.label, (float)this.getWidth() + 7.0f, (float)fy);
                ++i2;
            }
        }
        if (ts.viewProfile.showMilestones) {
            double sx = this.getWidth() / (end - from);
            MilestoneSpec mss = trend.milestones;
            ArrayList<Milestone> ls = mss.milestones;
            if (!ls.isEmpty()) {
                Line2D.Double line = new Line2D.Double(0.0, 0.0, 0.0, h);
                g2d.setStroke(MILESTONE_LINE_STROKE);
                Rectangle2D.Double diamondRegion = new Rectangle2D.Double(0.0, -14.0, w, 14.0);
                int i3 = mss.milestones.size() - 1;
                while (i3 >= 0) {
                    Milestone ms = mss.milestones.get(i3);
                    if (!ms.hidden) {
                        boolean isBaseline = i3 == mss.baseline;
                        double time2 = ms.time;
                        double x = (time2 - from) * sx;
                        if (!(x < -14.0) && !(x > w + 14.0)) {
                            x = Math.floor(x);
                            g2d.setClip(diamondRegion);
                            g2d.translate(x, 0.0);
                            g2d.setColor(isBaseline ? Color.LIGHT_GRAY : Color.DARK_GRAY);
                            g2d.fill(DIAMOND);
                            g2d.setColor(Color.BLACK);
                            g2d.draw(DIAMOND);
                            Font f = isBaseline ? BASELINE_FONT : MILESTONE_FONT;
                            g2d.setFont(f);
                            g2d.setColor(isBaseline ? Color.black : Color.ORANGE);
                            GlyphVector glyphVector = f.createGlyphVector(g2d.getFontRenderContext(), ms.label);
                            double cx = glyphVector.getVisualBounds().getCenterX();
                            double cy = glyphVector.getVisualBounds().getHeight();
                            g2d.drawString(ms.label, (float)(-cx), (float)(-7.0 + cy / 2.0));
                            g2d.setClip(null);
                            if (x >= 0.0 && x < w) {
                                g2d.setColor(Color.BLACK);
                                g2d.draw(line);
                            }
                            g2d.translate(-x, 0.0);
                        }
                    }
                    --i3;
                }
            }
        }
        if ((time = trend.valueTipTime) != null && time >= from && time <= end && !Double.isNaN(time)) {
            double sx = this.getWidth() / (end - from);
            double x = (time - from) * sx;
            Line2D.Double line = new Line2D.Double(x, 0.0, x, h);
            g2d.setStroke(DASHED_LINE_STROKE_2);
            g2d.setColor(trend.valueTipHover ? Color.GRAY : Color.WHITE);
            g2d.draw(line);
            g2d.setStroke(DASHED_LINE_STROKE);
            g2d.setColor(Color.BLACK);
            g2d.draw(line);
        }
        g2d.setStroke(BORDER_LINE_STROKE);
        g2d.setColor(Color.BLACK);
        Rectangle2D.Double rect = new Rectangle2D.Double();
        rect.setFrame(0.0, 0.0, w, h);
        g2d.draw(rect);
    }

    public void drawItem(Graphics2D g, ItemNode data, double y, double height, int phase) {
        TrendNode trend = this.getTrend();
        double from = trend.horizRuler.from;
        double end = trend.horizRuler.end;
        VertRuler ruler = data.ruler;
        AffineTransform at = g.getTransform();
        try {
            g.translate(0.0, y);
            g.setStroke(data.stroke);
            AffineTransform ab = new AffineTransform();
            if (data.item.renderer == TrendItem.Renderer.Analog) {
                ab.scale(this.getWidth() / (end - from), height / (ruler.min - ruler.max));
                ab.translate(-from, -ruler.max);
                data.draw(g, phase, false);
            }
            if (data.item.renderer == TrendItem.Renderer.Binary) {
                ab.scale(this.getWidth() / (end - from), 1.0);
                ab.translate(-from, 0.0);
                data.draw(g, phase, false);
            }
        }
        finally {
            g.setTransform(at);
        }
    }

    public void prepareItem(ItemNode data, double y, double height) {
        TrendNode tn = this.getTrend();
        double from = tn.horizRuler.from;
        double end = tn.horizRuler.end;
        VertRuler ruler = data.ruler;
        try {
            double pixelsPerSecond = (end - from) / this.getWidth();
            AffineTransform ab = new AffineTransform();
            if (data.item.renderer == TrendItem.Renderer.Analog) {
                ab.scale(this.getWidth() / (end - from), height / (ruler.min - ruler.max));
                ab.translate(-from, -ruler.max);
                data.prepareLine(from, end, pixelsPerSecond, ab);
            }
            if (data.item.renderer == TrendItem.Renderer.Binary) {
                ab.scale(this.getWidth() / (end - from), 1.0);
                ab.translate(-from, 0.0);
                data.prepareLine(from, end, pixelsPerSecond, ab);
            }
        }
        catch (HistoryException e) {
            e.printStackTrace();
        }
        catch (AccessorException e) {
            e.printStackTrace();
        }
    }

    void drawValuetip(Graphics2D g, double time) throws HistoryException, BindingException {
        boolean actuallyMoreThan;
        TrendNode trend = this.getTrend();
        Font font = TOOLTIP_FONT;
        FontMetrics fm = g.getFontMetrics(font);
        double marginInPlot = 7.0;
        double marginOnFilm = 5.0;
        double marginBetweenNamesAndValues = 16.0;
        double quantumWidthOfValueArea = 20.0;
        double marginBetweenLines = 5.0;
        double textAreaHeight = 0.0;
        double textAreaWidth = 0.0;
        double valueAreaLeft = 0.0;
        double valueAreaRight = 0.0;
        double valueAreaWidth = 0.0;
        ArrayList<TipLine> tipLines = new ArrayList<TipLine>(trend.allItems.size() + 1);
        TipLine tl = new TipLine();
        tipLines.add(tl);
        tl.label = "Time";
        LineMetrics lm = fm.getLineMetrics(tl.label, g);
        tl.height = lm.getHeight();
        tl.labelBaseline = fm.getAscent();
        textAreaHeight += marginBetweenLines;
        textAreaHeight += tl.height;
        tl.labelWidth = fm.stringWidth(tl.label);
        textAreaWidth = Math.max(tl.labelWidth, textAreaWidth);
        tl.color = Color.WHITE;
        NumberFormat f = NumberFormat.getInstance();
        if (trend.timeFormat == TimeFormat.Time) {
            f = new org.simantics.utils.format.TimeFormat(trend.horizRuler.iEnd, 3);
        }
        double t = time - trend.horizRuler.basetime;
        String formattedTime = f.format((Object)(time - trend.horizRuler.basetime));
        double roundedTime = t;
        try {
            roundedTime = (Double)f.parseObject(formattedTime);
        }
        catch (ParseException parseException) {}
        boolean actuallyLessThan = t < roundedTime;
        boolean bl = actuallyMoreThan = t > roundedTime;
        tl.value = actuallyLessThan ? "< " + formattedTime : (actuallyMoreThan ? "> " + formattedTime : formattedTime);
        tl.valueWidth = fm.stringWidth(tl.value);
        valueAreaWidth = Math.max(valueAreaWidth, tl.valueWidth);
        Format fmt = trend.valueFormat.toFormat(trend.decimals);
        for (ItemNode i : trend.allItems) {
            TipLine tl2 = new TipLine();
            tipLines.add(tl2);
            tl2.label = i.item.label;
            LineMetrics lm2 = fm.getLineMetrics(tl2.label, g);
            tl2.height = lm2.getHeight();
            tl2.labelBaseline = fm.getAscent();
            textAreaHeight += tl2.height;
            textAreaHeight += marginBetweenLines;
            tl2.labelWidth = fm.stringWidth(tl2.label);
            textAreaWidth = Math.max(tl2.labelWidth, textAreaWidth);
            tl2.color = ColorUtil.gamma((Color)i.color, (double)0.55);
            Stream s = i.openStream(0.0);
            if (s == null) continue;
            int index = s.binarySearch((Binding)Bindings.DOUBLE, (Object)time);
            if (index < 0) {
                index = -index - 2;
            }
            if (index < 0 || index >= s.count()) continue;
            s.count();
            ValueBand vb = new ValueBand((Binding)s.sampleBinding);
            try {
                vb.setSample(s.accessor.get(index, (Binding)s.sampleBinding));
            }
            catch (AccessorException e) {
                throw new HistoryException((Throwable)e);
            }
            if (vb.getSample() == null || vb.isNanSample() || vb.isNullValue()) continue;
            Binding b = vb.getValueBinding();
            if (b instanceof NumberBinding) {
                double v = vb.getValueDouble();
                tl2.value = fmt.format(v);
                tl2.number = true;
                int desimalPos = tl2.value.indexOf(46);
                if (desimalPos < 0) {
                    desimalPos = tl2.value.indexOf(44);
                }
                if (desimalPos >= 0) {
                    String beforeDesimal = tl2.value.substring(0, desimalPos);
                    String afterDesimal = tl2.value.substring(desimalPos, tl2.value.length());
                    tl2.valueLeftWidth = fm.stringWidth(beforeDesimal);
                    tl2.valueRightWidth = fm.stringWidth(afterDesimal);
                    tl2.valueWidth = tl2.valueLeftWidth + tl2.valueRightWidth;
                } else {
                    tl2.valueWidth = tl2.valueLeftWidth = (double)fm.stringWidth(tl2.value);
                }
                valueAreaWidth = Math.max(valueAreaWidth, tl2.valueLeftWidth + tl2.valueRightWidth);
                valueAreaLeft = Math.max(valueAreaLeft, tl2.valueLeftWidth);
                valueAreaRight = Math.max(valueAreaRight, tl2.valueRightWidth);
                continue;
            }
            Object v = vb.getValue();
            tl2.value = b.toString(v);
            tl2.number = false;
            tl2.valueLeftWidth = tl2.valueRightWidth = (double)fm.stringWidth(tl2.value);
            valueAreaWidth = Math.max(valueAreaWidth, tl2.valueLeftWidth);
        }
        double halfQuantum = quantumWidthOfValueArea / 2.0;
        valueAreaWidth = Math.ceil(valueAreaWidth / quantumWidthOfValueArea) * quantumWidthOfValueArea;
        valueAreaLeft = Math.ceil(valueAreaLeft / halfQuantum) * halfQuantum;
        valueAreaRight = Math.ceil(valueAreaRight / halfQuantum) * halfQuantum;
        double finalValueAreaWidth = Math.max(valueAreaWidth, valueAreaLeft + valueAreaRight);
        double w = marginOnFilm + textAreaWidth + marginBetweenNamesAndValues + finalValueAreaWidth + marginOnFilm + 0.0;
        double h = marginOnFilm + textAreaHeight + marginOnFilm;
        double maxX = trend.plot.getWidth() - marginInPlot - w;
        double maxY = trend.plot.getHeight() - marginInPlot - h;
        double x = marginInPlot + (maxX - marginInPlot) * trend.spec.viewProfile.valueViewPositionX;
        double y = marginInPlot + (maxY - marginInPlot) * trend.spec.viewProfile.valueViewPositionY;
        if (x < 10.0) {
            x = 10.0;
        }
        this.valueTipBoxBounds.setFrame(x, y, w, h);
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, w, h);
        Composite oldComposite = g.getComposite();
        AffineTransform oldTransform = g.getTransform();
        try {
            g.setComposite(composite66);
            g.translate(x, y);
            g.setColor(Color.BLACK);
            g.fill(rect);
            g.setFont(font);
            g.setComposite(oldComposite);
            y = marginInPlot;
            for (TipLine tl3 : tipLines) {
                g.setColor(tl3.color);
                x = marginInPlot;
                g.drawString(tl3.label, (float)x, (float)(y + tl3.labelBaseline));
                if (tl3.value != null) {
                    x = marginInPlot + textAreaWidth + marginBetweenNamesAndValues;
                    x = tl3.number ? (x += valueAreaLeft - tl3.valueLeftWidth) : (x += (finalValueAreaWidth - tl3.valueWidth) / 2.0);
                    g.drawString(tl3.value, (float)x, (float)(y + tl3.labelBaseline));
                }
                y += tl3.height;
                y += marginBetweenLines;
            }
        }
        finally {
            g.setTransform(oldTransform);
            g.setComposite(oldComposite);
        }
    }

    public void renderValueTip(Graphics2D g2d) {
        TrendNode trend = this.getTrend();
        if (trend.valueTipTime != null) {
            AffineTransform at = g2d.getTransform();
            try {
                try {
                    g2d.transform(this.getTransform());
                    this.drawValuetip(g2d, trend.valueTipTime);
                }
                catch (HistoryException e) {
                    e.printStackTrace();
                    g2d.setTransform(at);
                }
                catch (BindingException e) {
                    e.printStackTrace();
                    g2d.setTransform(at);
                }
            }
            finally {
                g2d.setTransform(at);
            }
        }
    }

    public ItemNode pickItem(Point2D pt) {
        TrendNode trend = this.getTrend();
        double y = pt.getY() - this.getY();
        double x = pt.getX() - this.getX();
        if (y < this.analogAreaHeight || y > this.analogAreaHeight + this.binaryAreaHeight) {
            return null;
        }
        if (x < 0.0 || x + this.getX() > trend.getBounds().getWidth()) {
            return null;
        }
        int i = 0;
        while (i < trend.binaryItems.size()) {
            double sy = this.analogAreaHeight + (double)i * BINARY[3];
            double ey = this.analogAreaHeight + (double)(i + 1) * BINARY[3];
            if (y >= sy && y < ey) {
                return trend.binaryItems.get(i);
            }
            ++i;
        }
        return null;
    }

    static class TipLine {
        String label;
        String value;
        Color color;
        double labelWidth;
        double height;
        double valueLeftWidth;
        double valueRightWidth;
        double valueWidth;
        double labelBaseline;
        boolean number;

        TipLine() {
        }

        public String toString() {
            return "TipLine[label=" + this.label + ", value=" + this.value + ", color=" + String.valueOf(this.color) + ", labelWidth=" + this.labelWidth + ", height=" + this.height + ", valueLeftWidth=" + this.valueLeftWidth + ", valueRightWidth=" + this.valueRightWidth + ", valueWidth=" + this.valueWidth + ", labelBaseline=" + this.labelBaseline + ", number=" + this.number + "]";
        }
    }
}

