/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.trend;

import java.awt.Color;
import java.util.concurrent.Executor;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.participant.BackgroundPainter;
import org.simantics.g2d.participant.CanvasBoundsParticipant;
import org.simantics.g2d.participant.CanvasGrab;
import org.simantics.g2d.participant.KeyToCommand;
import org.simantics.g2d.participant.KeyUtil;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.g2d.participant.PanZoomRotateHandler;
import org.simantics.g2d.participant.PointerPainter;
import org.simantics.g2d.participant.RulerPainter;
import org.simantics.g2d.participant.SymbolUtil;
import org.simantics.g2d.participant.TimeParticipant;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.g2d.tooltip.TooltipParticipant;
import org.simantics.history.Collector;
import org.simantics.history.HistoryManager;
import org.simantics.scenegraph.g2d.events.command.CommandKeyBinding;
import org.simantics.simulation.data.Datasource;
import org.simantics.trend.configuration.TrendSpec;
import org.simantics.trend.impl.TrendNode;
import org.simantics.trend.impl.TrendParticipant;
import org.simantics.utils.datastructures.disposable.IDisposable;
import org.simantics.utils.datastructures.disposable.IDisposeListener;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.threads.IThreadWorkQueue;

public class TrendInitializer {
    public static CanvasContext defaultInitializeCanvas(CanvasContext cvsCtx, HistoryManager historian, Collector collector, Datasource simulation, TrendSpec trendSpec) {
        IHintContext h = cvsCtx.getDefaultHintContext();
        h.setHint(PanZoomRotateHandler.KEY_ADAPT_VIEWPORT_TO_RESIZED_CONTROL, (Object)false);
        h.setHint(PanZoomRotateHandler.KEY_DISABLE_PAN, (Object)true);
        h.setHint(PanZoomRotateHandler.KEY_DISABLE_ZOOM, (Object)true);
        cvsCtx.add((Object)new PanZoomRotateHandler(false));
        cvsCtx.add((Object)new TransformUtil());
        cvsCtx.add((Object)new CanvasGrab());
        cvsCtx.add((Object)new KeyUtil());
        cvsCtx.add((Object)new MouseUtil());
        cvsCtx.add((Object)new SymbolUtil());
        cvsCtx.add((Object)new TimeParticipant());
        cvsCtx.add((Object)new CanvasBoundsParticipant());
        TrendNode trendNode = (TrendNode)cvsCtx.getSceneGraph().addNode(TrendNode.class);
        trendNode.setHistorian(historian, collector);
        trendNode.setTrendSpec(trendSpec);
        TrendParticipant tp = new TrendParticipant();
        tp.setTrend(trendNode);
        cvsCtx.add((Object)tp);
        if (simulation != null) {
            TrendInitializer.attachStepListener(simulation, (ICanvasContext)cvsCtx, tp);
        }
        h.setHint(PointerPainter.KEY_PAINT_POINTER, (Object)true);
        cvsCtx.add((Object)new BackgroundPainter());
        h.setHint(Hints.KEY_GRID_COLOR, (Object)new Color(0.95f, 0.95f, 0.95f));
        h.setHint(Hints.KEY_BACKGROUND_COLOR, (Object)Color.WHITE);
        h.setHint(RulerPainter.KEY_RULER_BACKGROUND_COLOR, (Object)new Color(0.9f, 0.9f, 0.9f, 0.75f));
        h.setHint(RulerPainter.KEY_RULER_TEXT_COLOR, (Object)Color.BLACK);
        h.setHint(TimeParticipant.KEY_TIME_PULSE_INTERVAL, (Object)50L);
        h.setHint(TimeParticipant.KEY_TIMER_ENABLED, (Object)true);
        h.setHint(TrendParticipant.KEY_TREND_DRAW_INTERVAL, (Object)100L);
        cvsCtx.add((Object)new KeyToCommand(CommandKeyBinding.DEFAULT_BINDINGS));
        cvsCtx.add((Object)new TooltipParticipant());
        h.setHint(Hints.KEY_TOOL, (Object)Hints.POINTERTOOL);
        cvsCtx.assertParticipantDependencies();
        return cvsCtx;
    }

    public static TrendNode getTrendNode(CanvasContext ctx) {
        TrendParticipant tp = (TrendParticipant)((Object)ctx.getSingleItem(TrendParticipant.class));
        return tp.getTrend();
    }

    public static void attachStepListener(final Datasource datasource, ICanvasContext context, TrendParticipant tp) {
        final StepListener stepListener = new StepListener(tp);
        datasource.addListener((Datasource.DatasourceListener)stepListener);
        context.addDisposeListener(new IDisposeListener(){

            public void onDisposed(IDisposable sender) {
                datasource.removeListener(stepListener);
            }
        });
    }

    public static CanvasContext createDefaultCanvas(IThreadWorkQueue threadAccess, HistoryManager historian, Collector collector, Datasource simulation, TrendSpec trendSpec) {
        return TrendInitializer.defaultInitializeCanvas(new CanvasContext(threadAccess), historian, collector, simulation, trendSpec);
    }

    public static class StepListener
    implements Datasource.DatasourceListener {
        private final TrendParticipant trendParticipant;

        public StepListener(TrendParticipant trendParticipant) {
            this.trendParticipant = trendParticipant;
        }

        public void onStep(Datasource source) {
            TrendNode node = this.trendParticipant.getTrend();
            if (!node.allPast()) {
                node.datadirty = true;
            }
        }

        public Executor getExecutor() {
            return null;
        }
    }
}

