/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.tests.modelled.ui.rules;

import java.util.Collections;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.model.images.ImageRule;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.tests.modelled.ontology.TestsResource;
import org.simantics.tests.modelled.ui.ontology.TestsUIResource;

public class TestImageRule
implements ImageRule {
    private ImageDescriptor testImage;
    private ImageDescriptor testIgnoredImage;

    public TestImageRule(ReadGraph graph) throws DatabaseException {
        TestsUIResource TESTS = TestsUIResource.getInstance((ReadGraph)graph);
        this.testImage = (ImageDescriptor)graph.adapt(TESTS.testImage, ImageDescriptor.class);
        this.testIgnoredImage = (ImageDescriptor)graph.adapt(TESTS.testIgnoredImage, ImageDescriptor.class);
    }

    public boolean isCompatible(Class<?> contentType) {
        return Resource.class.equals(contentType);
    }

    public Map<String, ImageDescriptor> getImage(ReadGraph graph, Object content) throws DatabaseException {
        Resource resource = (Resource)content;
        Boolean ignored = (Boolean)graph.getPossibleRelatedValue2(resource, TestsResource.getInstance((ReadGraph)graph).ignore, (Binding)Bindings.BOOLEAN);
        if (ignored != null && ignored.booleanValue()) {
            return Collections.singletonMap("single", this.testIgnoredImage);
        }
        return Collections.singletonMap("single", this.testImage);
    }
}

