/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.tests.modelled.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.graphics.Image;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.scl.compiler.module.coverage.CombinedCoverage;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.reporting.AbstractSCLReportingHandler;
import org.simantics.tests.modelled.ontology.TestsResource;
import org.simantics.tests.modelled.ui.STSExecutionListener;
import org.simantics.tests.modelled.ui.STSTestSuiteProvider;
import org.simantics.tests.modelled.utils.ModelledSTSSuite;
import org.simantics.tests.modelled.utils.ModelledSTSTest;
import org.simantics.tests.modelled.utils.STSSuiteTestCollector;

public class STSTestSuiteModel {
    private Map<String, List<ModelledSTSTest.CommandSessionVariable>> storedVars = new HashMap<String, List<ModelledSTSTest.CommandSessionVariable>>();
    private STSSuite suite;
    private STSTest test;
    private final List<STSExecutionListener> listeners = new ArrayList<STSExecutionListener>();
    private Job currentJob;

    public void addListener(STSExecutionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(STSExecutionListener listener) {
        this.listeners.remove(listener);
    }

    public Object[] getElements() {
        if (this.suite != null) {
            return new Object[]{this.suite};
        }
        if (this.test != null) {
            return new Object[]{this.test};
        }
        return null;
    }

    public void execute() {
        String command = this.suite != null ? this.suite.getName() : this.test.getName();
        if (this.currentJob != null) {
            this.currentJob.cancel();
        }
        this.currentJob = new Job(command){

            protected IStatus run(IProgressMonitor monitor) {
                if (STSTestSuiteModel.this.suite != null) {
                    STSTestSuiteModel.this.executeSuite();
                } else if (STSTestSuiteModel.this.test != null) {
                    STSTestSuiteModel.this.executeTest();
                }
                return Status.OK_STATUS;
            }

            protected void canceling() {
                Thread thread = this.getThread();
                if (thread != null) {
                    thread.interrupt();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                thread = this.getThread();
                if (thread != null) {
                    thread.stop();
                }
            }
        };
        this.currentJob.schedule();
    }

    public void interrupt() {
        if (this.currentJob != null) {
            this.currentJob.cancel();
        }
    }

    private void testExecuted() {
        this.listeners.forEach(listener -> listener.testExecuted());
    }

    private void executeSuite() {
        STSTest[] sTSTestArray = this.suite.getChildren();
        int n = sTSTestArray.length;
        int n2 = 0;
        while (n2 < n) {
            STSTest test = sTSTestArray[n2];
            if (test.isIgnored()) {
                this.testExecuted();
                ++test.getParent().ignoredCount;
            } else {
                test.execute();
                this.testExecuted();
            }
            ++n2;
        }
    }

    private void executeTest() {
        this.test.execute();
        this.testExecuted();
    }

    public boolean hasChildren(Object element) {
        if (element instanceof STSTest) {
            return false;
        }
        if (element instanceof STSSuite) {
            STSSuite suite = (STSSuite)element;
            return suite.getChildren() != null ? suite.getChildren().length > 0 : false;
        }
        throw new IllegalArgumentException(element.toString());
    }

    public Object getParent(Object element) {
        if (element instanceof STSTest) {
            return ((STSTest)element).getParent();
        }
        if (element instanceof STSSuite) {
            return null;
        }
        throw new IllegalArgumentException(element.toString());
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof STSTest) {
            return null;
        }
        if (parentElement instanceof STSSuite) {
            STSSuite suite = (STSSuite)parentElement;
            return suite.getChildren();
        }
        throw new IllegalArgumentException(parentElement.toString());
    }

    public String getText(Object element) {
        if (element instanceof STSTest) {
            return ((STSTest)element).getLabel();
        }
        if (element instanceof STSSuite) {
            return ((STSSuite)element).getLabel();
        }
        throw new IllegalArgumentException(element.toString());
    }

    public Image getImage(Object element) {
        if (element instanceof STSSuite) {
            STSSuite suite = (STSSuite)element;
            if (suite.isRunning()) {
                return STSTestSuiteProvider.suiteRunningIcon;
            }
            if (suite.executed()) {
                return STSTestSuiteProvider.suiteOkIcon;
            }
            if (suite.failed()) {
                return STSTestSuiteProvider.suiteFailIcon;
            }
            return STSTestSuiteProvider.suiteIcon;
        }
        if (element instanceof STSTest) {
            STSTest test = (STSTest)element;
            if (test.isRunning) {
                return STSTestSuiteProvider.testRunningIcon;
            }
            if (test.executed) {
                return STSTestSuiteProvider.testOkIcon;
            }
            if (test.failed) {
                return STSTestSuiteProvider.testFailIcon;
            }
            return STSTestSuiteProvider.testIcon;
        }
        return null;
    }

    public void updateInput(final Resource root) {
        this.suite = null;
        this.test = null;
        try {
            Simantics.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    TestsResource TESTS = TestsResource.getInstance((ReadGraph)graph);
                    if (graph.isInstanceOf(root, TESTS.STSTest)) {
                        STSTestSuiteModel.this.test = new STSTest(STSSuiteTestCollector.toModelledTest((ReadGraph)graph, (Resource)root), null);
                    } else if (graph.isInstanceOf(root, TESTS.STSSuite)) {
                        ArrayList<ModelledSTSTest> tests = new ArrayList<ModelledSTSTest>();
                        for (Resource test : graph.getObjects(root, L0.ConsistsOf)) {
                            tests.add(STSSuiteTestCollector.toModelledTest((ReadGraph)graph, (Resource)test));
                        }
                        STSTestSuiteModel.this.suite = new STSSuite(STSSuiteTestCollector.toModelledSuite((ReadGraph)graph, (Resource)root, tests));
                    } else {
                        throw new IllegalArgumentException(root.toString());
                    }
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public List<String> getOutput(Object element) {
        if (element instanceof STSTest) {
            STSTest test = (STSTest)element;
            return test.getOutput();
        }
        return Collections.emptyList();
    }

    public int getStartedCount() {
        if (this.suite != null) {
            return this.suite.startedCount;
        }
        return 0;
    }

    public int getIgnoredCount() {
        if (this.suite != null) {
            return this.suite.ignoredCount;
        }
        return 0;
    }

    public int getTotalCount() {
        if (this.suite != null && this.suite.getChildren() != null) {
            return this.suite.getChildren().length;
        }
        if (this.test != null) {
            return 1;
        }
        return 0;
    }

    public int getErrorCount() {
        if (this.suite != null) {
            return this.suite.errorCount;
        }
        return 0;
    }

    public int getFailureCount() {
        if (this.suite != null) {
            return this.suite.failureCount;
        }
        return 0;
    }

    public int getAssumptionFailureCount() {
        return 0;
    }

    public boolean isStopped() {
        if (this.suite != null) {
            return !this.suite.isRunning();
        }
        return this.test.isRunning;
    }

    class STSSuite {
        private ModelledSTSSuite suite;
        private STSTest[] children;
        private int startedCount;
        private int errorCount;
        private int failureCount;
        public int ignoredCount;

        public STSSuite(ModelledSTSSuite suite) {
            this.suite = suite;
        }

        public STSTest[] getChildren() {
            if (this.children == null) {
                this.children = this.suite.getSortedChildren().stream().map(modelledTest -> new STSTest((ModelledSTSTest)modelledTest, this)).collect(Collectors.toList()).toArray(new STSTest[this.suite.getChildren().size()]);
            }
            return this.children;
        }

        public String getName() {
            return this.suite.getName();
        }

        public String getLabel() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getName());
            long totalTime = 0L;
            if (this.getChildren() != null) {
                STSTest[] sTSTestArray = this.getChildren();
                int n = sTSTestArray.length;
                int n2 = 0;
                while (n2 < n) {
                    STSTest test = sTSTestArray[n2];
                    if (test.executed || test.failed) {
                        totalTime += test.duration;
                    }
                    ++n2;
                }
            }
            if (totalTime != 0L) {
                sb.append(" (").append(totalTime).append(" ms)");
            }
            return sb.toString();
        }

        public boolean isRunning() {
            if (this.getChildren() != null) {
                STSTest[] sTSTestArray = this.getChildren();
                int n = sTSTestArray.length;
                int n2 = 0;
                while (n2 < n) {
                    STSTest test = sTSTestArray[n2];
                    if (test.isRunning) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        public boolean executed() {
            if (this.getChildren() != null) {
                STSTest[] sTSTestArray = this.getChildren();
                int n = sTSTestArray.length;
                int n2 = 0;
                while (n2 < n) {
                    STSTest test = sTSTestArray[n2];
                    if (!test.executed) {
                        return false;
                    }
                    ++n2;
                }
            }
            return true;
        }

        public boolean failed() {
            if (this.getChildren() != null) {
                STSTest[] sTSTestArray = this.getChildren();
                int n = sTSTestArray.length;
                int n2 = 0;
                while (n2 < n) {
                    STSTest test = sTSTestArray[n2];
                    if (test.failed) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        public CombinedCoverage getCoverage() {
            return this.suite.getCoverage();
        }
    }

    class STSTest {
        private final ModelledSTSTest test;
        private final STSSuite parent;
        private boolean executed = false;
        private long duration;
        private boolean failed = false;
        private boolean isRunning = false;
        private List<String> output = new ArrayList<String>();

        public STSTest(ModelledSTSTest test, STSSuite parent) {
            this.test = test;
            this.parent = parent;
        }

        public String getName() {
            return this.test.getName();
        }

        public String getLabel() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getName());
            if (this.executed || this.failed) {
                sb.append(" (").append(this.duration).append(" ms)");
            }
            return sb.toString();
        }

        public String getDefinition() {
            return this.test.getCode();
        }

        public STSSuite getParent() {
            return this.parent;
        }

        public void execute() {
            this.isRunning = true;
            long start = System.currentTimeMillis();
            Object old = SCLContext.getCurrent().get((Object)"reportingHandler");
            try {
                try {
                    if (this.parent != null) {
                        ++this.parent.startedCount;
                    }
                    SCLContext.getCurrent().put((Object)"reportingHandler", (Object)new AbstractSCLReportingHandler(){

                        public void print(String text) {
                            STSTest.this.appendOutput(text + "\n");
                        }

                        public void printCommand(String command) {
                            STSTest.this.appendOutput("> " + command + "\n");
                        }

                        public void printError(String error) {
                            STSTest.this.appendOutput(error + "\n");
                        }
                    });
                    ArrayList<ModelledSTSTest.CommandSessionVariable> resolvedVars = new ArrayList<ModelledSTSTest.CommandSessionVariable>();
                    for (String deps : this.test.getDependencies()) {
                        List<ModelledSTSTest.CommandSessionVariable> vars = STSTestSuiteModel.this.storedVars.get(deps);
                        if (vars == null) continue;
                        resolvedVars.addAll(vars);
                    }
                    List vars = this.test.run(resolvedVars);
                    STSTestSuiteModel.this.storedVars.put(this.test.getName(), vars);
                    this.executed = true;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    if (this.parent != null) {
                        ++this.parent.failureCount;
                    }
                    this.failed = true;
                    this.isRunning = false;
                    long end = System.currentTimeMillis();
                    this.duration = end - start;
                    SCLContext.getCurrent().put((Object)"reportingHandler", old);
                }
            }
            finally {
                this.isRunning = false;
                long end = System.currentTimeMillis();
                this.duration = end - start;
                SCLContext.getCurrent().put((Object)"reportingHandler", old);
            }
        }

        protected void appendOutput(String text) {
            this.output.add(text);
        }

        public List<String> getOutput() {
            return this.output;
        }

        public void setCoverage(CombinedCoverage coverage) {
            this.test.setCoverage(coverage);
        }

        public CombinedCoverage getCoverage() {
            return this.test.getCoverage();
        }

        public int getPriority() {
            return this.test.getPriority();
        }

        public String toString() {
            return this.getName() + " [priority=" + this.getPriority() + ", executed=" + this.executed + ", duration=" + this.duration + "]";
        }

        public boolean isIgnored() {
            return this.test.isIgnored();
        }
    }
}

