/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.tests.modelled.ui;

import java.text.DecimalFormat;
import java.util.Collection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.simantics.scl.compiler.module.coverage.CombinedCoverage;
import org.simantics.scl.compiler.module.coverage.Coverage;
import org.simantics.scl.compiler.module.coverage.FunctionCoverage;
import org.simantics.scl.compiler.module.coverage.ModuleCoverage;
import org.simantics.tests.modelled.ui.STSTestSuiteModel;

public class STSCoverageProvider
extends LabelProvider
implements ITreeContentProvider {
    private Object input;
    private static final DecimalFormat MAX_PERCENTAGE_STRING = new DecimalFormat("0.0 %");

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.input = newInput;
    }

    public Object[] getElements(Object inputElement) {
        CombinedCoverage coverage;
        if (this.input instanceof STSTestSuiteModel.STSTest) {
            STSTestSuiteModel.STSTest test = (STSTestSuiteModel.STSTest)this.input;
            coverage = test.getCoverage();
        } else if (this.input instanceof STSTestSuiteModel.STSSuite) {
            STSTestSuiteModel.STSSuite suite = (STSTestSuiteModel.STSSuite)this.input;
            coverage = suite.getCoverage();
        } else {
            return new Object[0];
        }
        if (coverage == null) {
            return new Object[0];
        }
        return new Object[]{coverage};
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof CombinedCoverage) {
            CombinedCoverage coverage = (CombinedCoverage)parentElement;
            Collection moduleCoverages = coverage.moduleCoverages.values();
            return moduleCoverages.toArray(new ModuleCoverage[moduleCoverages.size()]);
        }
        if (parentElement instanceof ModuleCoverage) {
            ModuleCoverage coverage = (ModuleCoverage)parentElement;
            Collection coverages = coverage.functionCoverages.values();
            return coverages.toArray(new FunctionCoverage[coverages.size()]);
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof FunctionCoverage) {
            FunctionCoverage cfr_ignored_0 = (FunctionCoverage)element;
            return new ModuleCoverage[1];
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof CombinedCoverage) {
            return !((CombinedCoverage)element).moduleCoverages.isEmpty();
        }
        if (element instanceof ModuleCoverage) {
            return !((ModuleCoverage)element).functionCoverages.isEmpty();
        }
        return false;
    }

    public String getText(Object element) {
        if (element instanceof Coverage) {
            return ((Coverage)element).getIdentifier();
        }
        return super.getText(element);
    }

    public String getRatio(Object element) {
        if (element instanceof Coverage) {
            return STSCoverageProvider.formatPercentage(((Coverage)element).getCoverage());
        }
        return "unknown " + String.valueOf(element);
    }

    public String getCovered(Object element) {
        if (element instanceof Coverage) {
            return "" + ((Coverage)element).getCoveredCodeSize();
        }
        return "unknown " + String.valueOf(element);
    }

    public String getMissed(Object element) {
        if (element instanceof Coverage) {
            return "" + ((Coverage)element).getMissedCodeSize();
        }
        return "unknown " + String.valueOf(element);
    }

    public String getTotal(Object element) {
        if (element instanceof Coverage) {
            return "" + ((Coverage)element).getTotalCodeSize();
        }
        return "unknown " + String.valueOf(element);
    }

    private static String formatPercentage(double perc) {
        return MAX_PERCENTAGE_STRING.format(perc);
    }
}

