package org.simantics.tests.modelled.ui;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class Activator extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "org.simantics.tests.modelled.ui"; //$NON-NLS-1$

	// The shared instance
	private static Activator plugin;
	
	/**
	 * The constructor
	 */
	public Activator() {
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		imagesToDispose.forEach(Resource::dispose);
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static Activator getDefault() {
		return plugin;
	}

    public static ImageDescriptor getImageDescriptor(String relativePath) {
        URL url = getDefault().getBundle().getEntry(relativePath);
        return ImageDescriptor.createFromURL(url);
    }
    
    private static List<Image> imagesToDispose = new ArrayList<>();

    public static Image createManagedImage(ImageDescriptor descriptor) {
        Image image= descriptor.createImage();
        if (image == null) {
            image= ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        imagesToDispose.add(image);
        return image;
    }
}
