/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.team.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.simantics.db.exception.DatabaseException;

public class CommentDialog
extends Dialog {
    Label lName;
    Text tName;
    Data data;

    public static boolean openCommentDialog(final Data data) throws DatabaseException {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                CommentDialog d = new CommentDialog(display.getActiveShell(), data);
                data.ok = d.open() == 0;
            }
        });
        return data.ok;
    }

    public CommentDialog(Shell parentShell, Data data) {
        super(parentShell);
        this.data = data;
        this.setShellStyle(2160);
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().margins(8, 8).numColumns(9).applyTo(c);
        GridDataFactory gd1 = GridDataFactory.fillDefaults().span(1, 1);
        GridDataFactory gd2 = GridDataFactory.fillDefaults().grab(true, false).span(8, 1);
        this.lName = new Label(c, 0);
        this.lName.setText("Comment:");
        gd1.applyTo((Control)this.lName);
        this.tName = new Text(c, 2048);
        this.tName.setEnabled(true);
        if (this.data.comment != null) {
            this.tName.setText(this.data.comment);
        }
        gd2.applyTo((Control)this.tName);
        return c;
    }

    protected void okPressed() {
        this.data.comment = this.tName.getText();
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.data.title);
    }

    public static class Data {
        public boolean ok;
        public final String title;
        public String comment;

        public Data(String title) {
            this.title = title;
        }
    }
}

