/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.team.ui;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.simantics.Simantics;
import org.simantics.team.Activator;

/**
 * @author Kalle Kondelin
 */
public class RedoView extends TreeView {
    @Override
    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.treeViewer = new TreeViewer(parent, SWT.SINGLE | SWT.FULL_SELECTION);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(parent.getDisplay()), treeViewer.getTree());
        TreeColumnLayout ad = new TreeColumnLayout();
        parent.setLayout(ad);
        treeViewer.getTree().setHeaderVisible(true);
        //treeViewer.getTree().setLinesVisible(true);
        //treeViewer.setUseHashlookup(true);
        //treeViewer.setAutoExpandLevel(3);

        TreeViewerColumn idColumn = new TreeViewerColumn(treeViewer, SWT.LEFT);
        TreeViewerColumn dateColumn = new TreeViewerColumn(treeViewer, SWT.LEFT);
        TreeViewerColumn commentColumn = new TreeViewerColumn(treeViewer, SWT.LEFT);

        idColumn.setLabelProvider(new IdColumnLabelProvider());
        dateColumn.setLabelProvider(new DateColumnLabelProvider());
        commentColumn.setLabelProvider(new CommentColumnLabelProvider());

        idColumn.getColumn().setText("Id");
        idColumn.getColumn().setWidth(20);
        ad.setColumnData(idColumn.getColumn(), new ColumnWeightData(50, 20));
        dateColumn.getColumn().setText("Date");
        dateColumn.getColumn().setWidth(20);
        ad.setColumnData(dateColumn.getColumn(), new ColumnWeightData(50, 40));
        commentColumn.getColumn().setText("Comment");
        commentColumn.getColumn().setWidth(20);
        ad.setColumnData(commentColumn.getColumn(), new ColumnWeightData(50, 50));

        final RedoContentProvider contentProvider = new RedoContentProvider(Simantics.getSession());
          treeViewer.setContentProvider(contentProvider);
          treeViewer.setInput(this);
          getViewSite().getActionBars().getToolBarManager().add(new Action("Remove All", Activator.REMOVE_ALL_ICON) {
              @Override
              public void run() {
                  contentProvider.removeAll();
              }
          });
          getViewSite().getActionBars().getToolBarManager().add(new Action("Get Redo History", Activator.REFRESH_ICON) {
              @Override
              public void run() {
                  treeViewer.setContentProvider(contentProvider);
              }
          });
          new ItemDetailToolTip(treeViewer, treeViewer.getTree(), null);
    }

}
