package org.simantics.team.internal;

/**
 * A parallel interface for ITaskManager suited for use with the
 * org.simantics.datatype MethodInterface RPC mechanism.
 * 
 * Differences:
 *  - void return values not supported (will be supported in the future)
 * 
 * @author Tuukka Lehtonen
 */
public interface ImportCoordinator {

    int completed(double amount);
    int subTask(String name);
    int error(Exception e);
    int error(String message, Exception e);
    int error(String message);
    int warning(String message);
    int message(String message);
    int debug(String message);
    boolean isCanceled();

    int sendData(String key, String value);

}
