/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.team;

import java.net.URL;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.simantics.team.internal.Images;
import org.simantics.utils.ui.BundleUtils;

/**
 * The activator class controls the plug-in life cycle
 */
public class Activator extends AbstractUIPlugin {

    // The plug-in ID
    public static final String PLUGIN_ID = "org.simantics.team.ui";

    // The shared instance
    private static Activator plugin;

    /**
     * The constructor
     */
    public Activator() {
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext
     * )
     */
    public static ImageDescriptor DOOR_IN_ICON;
    public static ImageDescriptor DOOR_OUT_ICON;
    public static ImageDescriptor BIN_ICON;
    public static ImageDescriptor BIN_CLOSED_ICON;
    public static ImageDescriptor BIN_EMPTY_ICON;
    public static ImageDescriptor REFRESH_ICON;
    public static ImageDescriptor CHANGE_SET_ICON;
    public static ImageDescriptor DISPLAY_ICON;
    public static ImageDescriptor RESOURCE_ICON;
    public static ImageDescriptor STRING_ICON;
    public static ImageDescriptor COMBINED_ICON;
    public static ImageDescriptor UNDO_ICON;
    public static ImageDescriptor REDO_ICON;
    public static ImageDescriptor OTHER_ICON;
    public static ImageDescriptor REMOVE_ALL_ICON;
    public static ImageDescriptor NEXT_ICON;
    public static ImageDescriptor PREVIOUS_ICON;
    public static ImageDescriptor DEBUG_ICON;
    public static ImageDescriptor EXIT_ICON;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        DOOR_IN_ICON = ImageDescriptor.createFromURL(new URL("platform:/plugin/com.famfamfam.silk/icons/door_out.png"));
        DOOR_OUT_ICON = ImageDescriptor.createFromURL(new URL("platform:/plugin/com.famfamfam.silk/icons/door_in.png"));
        BIN_ICON = ImageDescriptor.createFromURL(new URL("platform:/plugin/com.famfamfam.silk/icons/bin.png"));
        BIN_CLOSED_ICON = ImageDescriptor.createFromURL(new URL("platform:/plugin/com.famfamfam.silk/icons/bin_closed.png"));
        BIN_EMPTY_ICON = ImageDescriptor.createFromURL(new URL("platform:/plugin/com.famfamfam.silk/icons/bin_empty.png"));
        REFRESH_ICON = ImageDescriptor.createFromURL(new URL("platform:/plugin/com.famfamfam.silk/icons/arrow_refresh.png"));
        CHANGE_SET_ICON = BundleUtils.getImageDescriptorFromPlugin("com.famfamfam.silk", "icons/book.png");
        DISPLAY_ICON = BundleUtils.getImageDescriptorFromPlugin("com.famfamfam.silk", "icons/anchor.png");
        RESOURCE_ICON = BundleUtils.getImageDescriptorFromPlugin("com.famfamfam.silk", "icons/application.png");
        STRING_ICON = BundleUtils.getImageDescriptorFromPlugin("com.famfamfam.silk", "icons/star.png");
        COMBINED_ICON = BundleUtils.getImageDescriptorFromPlugin("com.famfamfam.silk", "icons/basket.png");
        REDO_ICON = BundleUtils.getImageDescriptorFromPlugin("com.famfamfam.silk", "icons/arrow_redo.png");
        UNDO_ICON = BundleUtils.getImageDescriptorFromPlugin("com.famfamfam.silk", "icons/arrow_undo.png");
        OTHER_ICON = BundleUtils.getImageDescriptorFromPlugin("com.famfamfam.silk", "icons/bell.png");
        REMOVE_ALL_ICON = BundleUtils.getImageDescriptorFromPlugin("com.famfamfam.silk", "icons/cross.png");
        NEXT_ICON = BundleUtils.getImageDescriptorFromPlugin("com.famfamfam.silk", "icons/book_next.png");
        PREVIOUS_ICON = BundleUtils.getImageDescriptorFromPlugin("com.famfamfam.silk", "icons/book_previous.png");
        DEBUG_ICON = ImageDescriptor.createFromURL(new URL("platform:/plugin/com.famfamfam.silk/icons/bomb.png"));
        EXIT_ICON = ImageDescriptor.createFromURL(new URL("platform:/plugin/com.famfamfam.silk/icons/hourglass.png"));
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext
     * )
     */
    public void stop(BundleContext context) throws Exception {
        Images.disposeInstance();
        plugin = null;
        super.stop(context);
    }

    /**
     * Returns the shared instance
     * 
     * @return the shared instance
     */
    public static Activator getDefault() {
        return plugin;
    }

}
