/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.ui.adapters;

import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Template;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.operation.Layer0X;

public class DiagramTemplate
implements Template {
    Resource template;

    public DiagramTemplate(Resource template) {
        this.template = template;
    }

    public void apply(WriteGraph g, Map<String, Object> parameters) throws DatabaseException {
        String name;
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)g);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)g);
        Resource composite = (Resource)parameters.get("");
        CommonDBUtils.selectClusterSet((WriteGraph)g, (Resource)composite);
        Resource diagramType = g.getSingleObject(this.template, mr.HasDiagramType);
        Resource diagram = (Resource)parameters.get("diagram");
        if (diagram == null) {
            diagram = g.newResource();
            parameters.put("diagram", diagram);
        }
        g.claim(diagram, l0.InstanceOf, null, diagramType);
        g.claim(diagram, l0.SubrelationOf, null, l0.HasNext);
        g.claim(diagram, mr.DiagramToComposite, composite);
        Resource diagramInv = g.newResource();
        g.claim(diagramInv, l0.InverseOf, diagram);
        g.claim(diagramInv, l0.SubrelationOf, null, l0.HasPrevious);
        g.claim(diagram, diagram, diagramInv, diagram);
        Resource mapping = g.newResource();
        g.claim(diagram, L0X.HasTrigger, mapping);
        Resource mappingType = g.getPossibleObject(this.template, mr.DiagramTemplate_HasMappingType);
        if (mappingType != null) {
            g.claim(mapping, l0.InstanceOf, mappingType);
        }
        if ((name = (String)parameters.get("name")) == null) {
            name = "__DIAGRAM__";
        }
        g.claimLiteral(diagram, l0.HasName, (Object)name, (Binding)Bindings.STRING);
        if (!g.hasStatement(diagram, l0.PartOf)) {
            Resource container = g.newResource();
            g.claim(container, l0.InstanceOf, null, DIA.DiagramContainer);
            g.addLiteral(container, l0.HasName, l0.NameOf, l0.String, (Object)"__CONTAINER__", (Binding)Bindings.STRING);
            g.claim(container, l0.ConsistsOf, diagram);
            g.claim(composite, l0.ConsistsOf, container);
        }
    }

    public double priority() {
        return 5.0;
    }
}

