/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural.ui.modelBrowser.nodes;

import org.eclipse.core.runtime.IAdaptable;
import org.simantics.db.Resource;

/**
 * A base for browser node classes that denies Resource adaptability through
 * {@link IAdaptable#getAdapter(Class)}
 * 
 * @author Tuukka Lehtonen
 */
public abstract class NoResourceNode extends AbstractNode {

    public NoResourceNode(Resource resource) {
        super(resource);
    }

    @SuppressWarnings("rawtypes")
    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == Resource.class)
            return null;
        return super.getAdapter(adapter);
    }

}
