/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural.ui.modelBrowser.contributions;

import org.simantics.browsing.ui.graph.contributor.labeler.LabelerContributor;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural.ui.modelBrowser.nodes.ConnectionNode;
import org.simantics.structural2.utils.StructuralUtils;

public class ConnectionLabeler extends LabelerContributor<ConnectionNode> {

	@Override
	public String getLabel(ReadGraph graph, ConnectionNode node) throws DatabaseException {
		StructuralResource2 sr = StructuralResource2.getInstance(graph);
		StringBuilder sb = new StringBuilder();
    	Layer0 b = Layer0.getInstance(graph);
		
		{
			boolean first = true;
			for(Resource component : graph.getObjects(node.connection, sr.Connects)) {
				if(first)
					first = false;
				else
					sb.append(", ");
				sb.append(graph.<String>getRelatedValue(component, b.HasName, Bindings.STRING));				
			}
		}
		sb.append(" -> ");
		{
			boolean first = true;
			for(Resource relatedConnection : StructuralUtils.getRelatedConnections(graph, node.connection)) {
				if(relatedConnection.equals(node.connection))
					continue;
				for(Resource component : graph.getObjects(relatedConnection, sr.Connects)) {
					if(first)
						first = false;
					else
						sb.append(", ");
					sb.append(graph.<String>getRelatedValue(component, b.HasName, Bindings.STRING));			
				}
			}
		}
		
		return sb.toString();
	}
	
	@Override
	public int getCategory(ReadGraph graph, ConnectionNode node) throws DatabaseException {
		return 1;
	}

}